/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.common;

import biz.elabor.prebilling.common.CountMapHandler;
import biz.elabor.prebilling.common.model.Applicazione;
import biz.elabor.prebilling.common.model.Contratto;
import biz.elabor.prebilling.common.model.TipoFlat;
import biz.elabor.prebilling.common.model.TipoProfilo;
import biz.elabor.prebilling.common.model.TipoTrattamento;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.structures.CountMap;
import org.homelinux.elabor.structures.StructuresHelper;

public class BasicServiceStatus {
    protected Map<String, CountMap<String>> results;
    @Deprecated
    private String fileResults;
    private Map<String, Applicazione> applicazioni;
    private Map<String, List<Applicazione>> subapplicazioni;
    private final String idEsecuzione;

    public BasicServiceStatus(String idEsecuzione) {
        this.idEsecuzione = idEsecuzione;
        this.results = new LinkedHashMap<String, CountMap<String>>();
        this.subapplicazioni = new HashMap<String, List<Applicazione>>();
    }

    public Map<String, CountMap<String>> getResults() {
        return this.results;
    }

    @Deprecated
    public String getFileResults() {
        return this.fileResults;
    }

    @Deprecated
    public void setFilesResults(String absolutePath) {
        this.fileResults = absolutePath;
    }

    public void count(String azienda, String flusso, int weight) {
        CountMap<String> azResults = this.getResults(azienda);
        azResults.increment(flusso, weight);
    }

    private CountMap<String> getResults(String azienda) {
        CountMap<String> countMap;
        CountMapHandler handler = new CountMapHandler();
        try {
            countMap = StructuresHelper.get(azienda, this.results, handler);
        }
        catch (DataNotFoundException exc) {
            throw new RuntimeException(exc);
        }
        return countMap;
    }

    public void setApplicazioni(Map<String, Applicazione> applicazioni) {
        this.applicazioni = applicazioni;
    }

    public Applicazione getApplicazione(Contratto contratto) {
        String reseller = contratto.getReseller();
        int tipoApp = contratto.getTipoApplicazione();
        return this.getApplicazione(reseller, tipoApp);
    }

    public Applicazione getApplicazione(String reseller, int tipoApp) {
        String key = Applicazione.getKey(reseller, tipoApp);
        Applicazione applicazione = this.applicazioni.get(key);
        if (applicazione == null && (applicazione = this.applicazioni.get(key = Applicazione.getKey("", tipoApp))) == null) {
            applicazione = new Applicazione("", tipoApp, TipoTrattamento.BOTH, TipoFlat.NON_FLAT, TipoProfilo.ANNUALE);
        }
        return applicazione;
    }

    private static String getSubappKey(Applicazione applicazione, int anno, Month mese) {
        return String.valueOf(applicazione.getKey()) + anno + mese.toString();
    }

    public List<Applicazione> getSubapplicazioni(Applicazione applicazione, int anno, Month mese) {
        String key = BasicServiceStatus.getSubappKey(applicazione, anno, mese);
        return this.subapplicazioni.get(key);
    }

    public void setSubapplicazioni(Applicazione applicazione, int anno, Month mese, List<Applicazione> subapplicazioni) {
        String key = BasicServiceStatus.getSubappKey(applicazione, anno, mese);
        this.subapplicazioni.put(key, subapplicazioni);
    }

    public String getIdEsecuzione() {
        return this.idEsecuzione;
    }

    public Logger getLogger() {
        return Logger.getLogger(this.idEsecuzione);
    }
}

