/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.common.dao;

import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.common.dao.BasicPrebillingDao;
import java.text.DateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import org.homelinux.elabor.db.ConnectionManager;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.db.DbmsType;
import org.homelinux.elabor.db.DuplicateKeyException;
import org.homelinux.elabor.db.QueryTemplate;
import org.homelinux.elabor.json.JsonTools;

public abstract class AbstractJdbcPrebillingDao
extends ConnectionManager
implements BasicPrebillingDao {
    public AbstractJdbcPrebillingDao(String host, DbmsType dbType, String dbName, String user, String password) {
        super(host, dbType, dbName, user, password);
    }

    @Override
    public void insertRun(String servizio, String idEsecuzione, Date inizio, String api, String reseller, LinkedHashMap<String, Object> params) {
        DateFormat dateFormat = StrategyCommonHelper.getTimestampFormat();
        QueryTemplate query = new QueryTemplate("INSERT INTO elaborazioni (servizio, id_esecuzione, inizio, api, reseller, params) VALUES (  :servizio:,  :id_esecuzione:,  to_timestamp(:inizio:, 'yyyymmddhh24miss'),  :api:,  :reseller:,  :params:)");
        query.replace(":servizio:", servizio);
        query.replace(":id_esecuzione:", idEsecuzione);
        query.replace(":inizio:", inizio, dateFormat);
        query.replace(":api:", api);
        query.replace(":reseller:", reseller);
        String jsonParams = JsonTools.toJson(params);
        query.replace(":params:", jsonParams);
        try {
            this.executeInsert(query);
        }
        catch (DuplicateKeyException exc) {
            throw new RuntimeException(exc);
        }
    }

    @Override
    public void updateRun(String idEsecuzione, Date fine) {
        DateFormat dateFormat = StrategyCommonHelper.getTimestampFormat();
        QueryTemplate query = new QueryTemplate("UPDATE elaborazioni SET fine=to_timestamp(:fine:, 'yyyymmddhh24miss') WHERE id_esecuzione=:id_esecuzione:");
        query.replace(":id_esecuzione:", idEsecuzione);
        query.replace(":fine:", fine, dateFormat);
        try {
            this.executeUpdate(query);
        }
        catch (DataNotFoundException | DuplicateKeyException exc) {
            throw new RuntimeException(exc);
        }
    }
}

