/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.config;

import biz.elabor.prebilling.common.config.InvalidConfigurationException;
import biz.elabor.prebilling.gas.config.ConfigurationGasInstance;
import biz.elabor.prebilling.gas.config.DefaultConfigurationGasInstance;
import biz.elabor.prebilling.gas.config.FileGasConfiguration;
import biz.elabor.prebilling.gas.dao.giada.JdbcGiadaGasDao;
import biz.elabor.prebilling.gas.dao.misure.JdbcMisureGasDao;
import java.io.File;
import java.io.IOException;
import java.util.InvalidPropertiesFormatException;
import java.util.logging.Logger;

public class GasConfigurationLoader {
    private final File folder;
    private final String version;

    public GasConfigurationLoader(File folder, String version) {
        this.folder = folder;
        this.version = version;
    }

    public ConfigurationGasInstance loadConfiguration(String configName) throws InvalidConfigurationException, InvalidPropertiesFormatException, IOException {
        DefaultConfigurationGasInstance configurationInstance;
        Logger logger = Logger.getLogger(this.getClass().getName());
        try {
            String fileName = String.valueOf(configName) + ".cfg";
            FileGasConfiguration config = new FileGasConfiguration(this.folder, fileName, this.version);
            JdbcMisureGasDao misureGasDao = new JdbcMisureGasDao(config);
            JdbcGiadaGasDao giadaGasDao = new JdbcGiadaGasDao(config);
            configurationInstance = new DefaultConfigurationGasInstance(misureGasDao, giadaGasDao, config);
            logger.info("caricata configurazione " + configName);
            logger.info("aperta connessione " + config.getMisureDbName() + "/" + config.getMisureDbUser());
            logger.info("aperta connessione " + config.getGiadaDbName() + "/" + config.getGiadaDbUser());
        }
        catch (RuntimeException exc) {
            logger.severe(exc.toString());
            throw new InvalidConfigurationException(configName);
        }
        return configurationInstance;
    }
}

