/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.dao.giada;

import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.gas.config.PrebillingGasConfiguration;
import biz.elabor.prebilling.gas.dao.giada.ContrattoGasCreator;
import biz.elabor.prebilling.gas.dao.giada.GiadaGasDao;
import biz.elabor.prebilling.gas.dao.giada.ProfiloPrelievoCreator;
import biz.elabor.prebilling.gas.dao.misure.JdbcMisureGasDao;
import biz.elabor.prebilling.gas.dao.misure.model.ContrattoGas;
import biz.elabor.prebilling.gas.dao.misure.model.ProfiloPrelievo;
import biz.elabor.prebilling.gas.services.common.ErroreElaborazioneGas;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.homelinux.elabor.db.ConnectionManager;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.db.QueryTemplate;
import org.homelinux.elabor.structures.listmap.DefaultListMapKey;
import org.homelinux.elabor.structures.listmap.ListMap;

public class JdbcGiadaGasDao
extends ConnectionManager
implements GiadaGasDao {
    private String queryOpzioniContrattualiGas;
    private String queryUltimaOpzioneContrattualeGas;

    public JdbcGiadaGasDao(PrebillingGasConfiguration configuration) throws IOException {
        super(configuration.getGiadaHost(), configuration.getGiadaType(), configuration.getGiadaDbName(), configuration.getGiadaDbUser(), configuration.getGiadaDbPassword());
        ClassLoader classLoader = JdbcMisureGasDao.class.getClassLoader();
        this.queryOpzioniContrattualiGas = JdbcGiadaGasDao.loadTemplate(classLoader, "query-opzioni-contrattuali-gas.sql");
        this.queryUltimaOpzioneContrattualeGas = JdbcGiadaGasDao.loadTemplate(classLoader, "query-ultima-opzione-contrattuale-gas.sql");
    }

    @Override
    public ListMap<String, ContrattoGas> getContratti(Date meseRif, String reseller, Set<String> pdrSet, boolean direttiOnly) {
        String pdrClause = pdrSet == null || pdrSet.isEmpty() ? "" : "CDPRERIF IN (:pdrset:) AND ";
        String direttiClause = direttiOnly ? "DIRETTO='D' AND " : "";
        String resellerClause = reseller.equals("*") ? "" : "CDAZIRIF=:reseller: AND";
        String template = this.queryOpzioniContrattualiGas.replace("<pdr-clause>", pdrClause).replace("<diretti-clause>", direttiClause).replace("<reseller-clause>", resellerClause);
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":pdrset:", pdrSet);
        DateFormat dateFormat = StrategyCommonHelper.getAnnoMeseDateFormat();
        query.replace(":mese_rif:", meseRif, dateFormat);
        query.replace(":reseller:", reseller);
        ContrattoGasCreator creator = new ContrattoGasCreator();
        DefaultListMapKey<String, ContrattoGas> contratti = new DefaultListMapKey<String, ContrattoGas>();
        this.buildClassifier(contratti, query, creator);
        return contratti;
    }

    @Override
    public ContrattoGas getUltimoContratto(String codicePdr) {
        QueryTemplate query = new QueryTemplate(this.queryUltimaOpzioneContrattualeGas);
        query.replace(":pdr:", codicePdr);
        ContrattoGasCreator creator = new ContrattoGasCreator();
        List<ContrattoGas> contratti = this.getRecords(query, creator);
        return contratti.isEmpty() ? null : contratti.get(0);
    }

    @Override
    public ProfiloPrelievo getProfiloPrelievo(String profilo, Date data) throws DataNotFoundException {
        QueryTemplate query = new QueryTemplate("select * from GAS_PROFILI_PRELIEVO where  CDPROPRE = :profilo:  and TO_CHAR(DATA_VALIDITA,'yyyy-mm-dd') = :data:");
        query.replace(":profilo:", profilo);
        DateFormat standardDateFormat = StrategyCommonHelper.getStandardDateFormat();
        query.replace(":data:", data, standardDateFormat);
        ProfiloPrelievoCreator creator = new ProfiloPrelievoCreator();
        String key = String.valueOf(profilo) + "-" + standardDateFormat.format(data);
        ErroreElaborazioneGas errore = ErroreElaborazioneGas.MISSING_PROFILO;
        String message = errore.getMessage();
        int ordinal = errore.ordinal();
        return this.getRecord(query, creator, message, key, ordinal);
    }
}

