/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.dao.misure;

import biz.elabor.prebilling.common.PrebillingError;
import biz.elabor.prebilling.common.model.IdFlusso;
import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.dao.TableMultiUpdateHandler;
import biz.elabor.prebilling.gas.services.common.GasResultRecord;
import java.sql.PreparedStatement;
import java.sql.SQLException;

class ResultTableMultiUpdateHandler<T extends IdFlusso>
implements TableMultiUpdateHandler<GasResultRecord<T>> {
    private final String tableName;

    public ResultTableMultiUpdateHandler(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public String getQuery() {
        return "update " + this.tableName + "  set STATO_TARIFFE_RESELLER=?, COD_ERRORE_TARIFFE_RESELLER=?, DESC_ERRORE_TARIFFE_RESELLER=?," + "  STATO=?, COD_ERRORE=?, DESC_ERRORE=?" + "  where id=?";
    }

    @Override
    public boolean prepare(PreparedStatement statement, GasResultRecord<T> item, StatoMisure ignore, String id) throws SQLException {
        StatoMisure stato = item.getStato();
        PrebillingError errore = (PrebillingError)item.getErrore();
        statement.setInt(1, stato.getCodice());
        statement.setInt(2, errore.getCodice());
        statement.setString(3, item.getMessaggio());
        statement.setInt(4, stato.getCodice());
        statement.setInt(5, errore.getCodice());
        statement.setString(6, item.getMessaggio());
        statement.setInt(7, Integer.parseInt(id));
        return true;
    }
}

