/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.services.common;

import biz.elabor.prebilling.common.utils.CommonDownloadPerseoHelper;
import biz.elabor.prebilling.common.utils.InvalidUrlException;
import biz.elabor.prebilling.common.utils.MissingCodicePerseoException;
import biz.elabor.prebilling.gas.dao.misure.model.Cliente;
import biz.elabor.prebilling.gas.services.StrategyHelper;
import biz.elabor.prebilling.gas.services.common.ErroreElaborazioneGas;
import biz.elabor.prebilling.gas.services.pcs.PcsAzienda;
import biz.elabor.prebilling.gas.services.tariffe.ConsumoRemi;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;

public class DownloadPerseoHelper
extends CommonDownloadPerseoHelper {
    private static final DateFormat LONG_DATE_FORMAT = StrategyHelper.getLongDateFormat();

    public static List<ConsumoRemi> downloadConsumiRemi(Cliente cliente, Date startDate, Date endDate, String direttiBaseUrl, Logger logger) throws DataNotFoundException, IOException, MissingCodicePerseoException {
        List<Double> consumi = DownloadPerseoHelper.downloadConsumi(cliente, startDate, endDate, direttiBaseUrl, logger);
        return DownloadPerseoHelper.buildConsumiRemi(startDate, consumi);
    }

    public static List<ConsumoRemi> buildConsumiRemi(Date startDate, List<Double> consumi) {
        ArrayList<ConsumoRemi> consumiRemi = new ArrayList<ConsumoRemi>();
        ElaborCalendar calendar = new ElaborCalendar(startDate);
        for (Double consumo : consumi) {
            Date date = calendar.getDate();
            ConsumoRemi consumoRemi = new ConsumoRemi(date, consumo);
            consumiRemi.add(consumoRemi);
            calendar.addGiorni(1);
        }
        return consumiRemi;
    }

    public static List<Double> downloadConsumi(Cliente cliente, int anno, Month mese, String direttiBaseUrl, Logger logger) throws DataNotFoundException, IOException, MissingCodicePerseoException {
        Date startDate = StrategyHelper.getStartDate(anno, mese, cliente);
        Date endDate = StrategyHelper.getEndDate(anno, mese, cliente);
        return DownloadPerseoHelper.downloadConsumi(cliente, startDate, endDate, direttiBaseUrl, logger);
    }

    public static List<Double> downloadConsumi(Cliente cliente, Date startDate, Date endDate, String direttiBaseUrl, Logger logger) throws IOException, DataNotFoundException, MissingCodicePerseoException {
        List<Double> values;
        String codicePerseo = cliente.getCodicePerseo();
        ErroreElaborazioneGas errore = ErroreElaborazioneGas.CONSUMI_INVALIDI;
        int segno = cliente.getSegno();
        try {
            values = DownloadPerseoHelper.downloadValues(cliente, startDate, endDate, segno, codicePerseo, direttiBaseUrl, errore, logger);
        }
        catch (InvalidUrlException exc) {
            String remi = cliente.getCodiceRemi();
            throw new MissingCodicePerseoException(remi, "consumi");
        }
        return values;
    }

    public static List<Double> downloadPcs(Cliente cliente, int anno, Month mese, String direttiBaseUrl, Logger logger) throws DataNotFoundException, IOException, MissingCodicePerseoException {
        List<Double> values;
        String codicePerseo = cliente.getCodicePerseoPcs();
        ErroreElaborazioneGas errore = ErroreElaborazioneGas.PCS_INVALIDI;
        try {
            Date startDate = StrategyHelper.getStartDate(anno, mese, cliente);
            Date endDate = StrategyHelper.getEndDate(anno, mese, cliente);
            values = DownloadPerseoHelper.downloadValues(cliente, startDate, endDate, 3603.5999999999995, codicePerseo, direttiBaseUrl, errore, logger);
        }
        catch (InvalidUrlException exc) {
            String remi = cliente.getCodiceRemi();
            throw new MissingCodicePerseoException(remi, "pcs");
        }
        return values;
    }

    private static List<Double> downloadValues(Cliente cliente, Date startDate, Date endDate, double coeff, String codicePerseo, String direttiBaseUrl, ErroreElaborazioneGas errore, Logger logger) throws IOException, DataNotFoundException, InvalidUrlException {
        DateFormat plainDateFormat = StrategyHelper.getPlainDateFormat();
        String startDateFmt = plainDateFormat.format(startDate);
        String endDateFmt = plainDateFormat.format(endDate);
        URL url = new URL(String.valueOf(direttiBaseUrl) + "/" + codicePerseo + "?startDate=" + startDateFmt + "&endDate=" + endDateFmt + "&dates=true" + "&simulation=0" + "&scenario=0");
        logger.info(url.toString());
        List<Double> values = DownloadPerseoHelper.getValues(url, coeff);
        if ((long)values.size() != CalendarTools.getDays(startDate, endDate) + 1L) {
            String message = errore.getMessage();
            String remi = cliente.getCodiceRemi();
            String key = String.valueOf(remi) + " - " + startDateFmt + " / " + endDateFmt;
            throw new DataNotFoundException(message, key, errore.ordinal());
        }
        return values;
    }

    public static boolean checkDates(Date startDate, Date endDate, List<ConsumoRemi> consumiPerseo) {
        Date expected;
        ElaborCalendar calendar = new ElaborCalendar(startDate);
        Iterator<ConsumoRemi> iterator = consumiPerseo.iterator();
        boolean ok = true;
        while (!(expected = calendar.getDate()).after(endDate)) {
            ConsumoRemi current;
            ConsumoRemi consumoRemi = current = iterator.hasNext() ? iterator.next() : null;
            if (current == null) {
                ok = false;
            } else {
                Date dataMisura = current.getDataMisura();
                if (dataMisura.equals(expected)) {
                    calendar.addGiorni(1);
                } else if (dataMisura.after(expected)) {
                    ok = false;
                }
            }
            if (ok) continue;
        }
        return ok;
    }

    public static ConsumoRemi createConsumo(String line) throws ParseException {
        String[] row = line.split(",");
        Double valore = Double.valueOf(row[1]);
        ConsumoRemi consumoPerseo = null;
        if (!valore.isNaN()) {
            Date dataMisura = LONG_DATE_FORMAT.parse(row[0]);
            double consumo = valore;
            consumoPerseo = new ConsumoRemi(dataMisura, consumo);
        }
        return consumoPerseo;
    }

    public static void addPcs(String azienda, Cliente cliente, List<Double> consumi, List<Double> pcs, Map<String, PcsAzienda> pcsAziende) {
        PcsAzienda pcsAzienda = pcsAziende.get(azienda);
        if (pcsAzienda == null) {
            pcsAzienda = new PcsAzienda();
            pcsAziende.put(azienda, pcsAzienda);
        }
        pcsAzienda.add(cliente, consumi, pcs);
    }
}

