/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.services.common;

import biz.elabor.prebilling.common.utils.ExportHelper;
import biz.elabor.prebilling.common.utils.ListWriter;
import biz.elabor.prebilling.gas.config.PrebillingGasConfiguration;
import biz.elabor.prebilling.gas.dao.misure.model.ContrattoGas;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class WriteLetstdGasService {
    private static final String CODICE_LETTURA = ExportHelper.fixedLength("", 15);
    private static final String FLPREACC = "0";
    private static final String TAPPO = ".";
    private static final String FILLER = "      ";
    private static final String QTSCATTI = "000000000000";
    private final DateFormat dateFormat;
    private final DecimalFormat decimalFormat;
    private final int lunghezzaMatricola;
    private final PrebillingGasConfiguration configuration;

    public WriteLetstdGasService(PrebillingGasConfiguration configuration) {
        this.lunghezzaMatricola = configuration.getLunghezzaMatricola();
        this.dateFormat = new SimpleDateFormat("ddMMyyyy0000");
        this.decimalFormat = new DecimalFormat("000000000.000");
        this.configuration = configuration;
    }

    public void write(ListWriter writer, ContrattoGas contratto, String matricola, Date data, double segnanteMisuratore, double segnanteConvertitore, String meslet, boolean convertitore) {
        String codicePdr = contratto.getCodice();
        String cdMesLet = this.configuration.getCdmeslet(meslet, "0000");
        String riga = this.createUserData(codicePdr, convertitore, matricola, segnanteMisuratore, data, cdMesLet);
        writer.print(riga, "\r\n");
        String rigaMisuratore = this.createTipoLettoreData(segnanteMisuratore, "$01");
        writer.print(rigaMisuratore, "\r\n");
        if (convertitore) {
            String rigaConvertitore = this.createTipoLettoreData(segnanteConvertitore, "$08");
            writer.print(rigaConvertitore, "\r\n");
        }
    }

    private String createTipoLettoreData(double misura, String startLine) {
        return String.valueOf(startLine) + ExportHelper.fixedLength("", this.lunghezzaMatricola) + this.getFormattedValue(misura) + QTSCATTI + this.getFormattedValue(0.0) + QTSCATTI + this.getFormattedValue(0.0) + QTSCATTI + this.getFormattedValue(0.0) + QTSCATTI + " " + TAPPO;
    }

    private String createUserData(String codicePdr, boolean convertitore, String matricola, double value, Date data, String cdmeslet) {
        String segnale = "1000" + (convertitore ? "4" : FLPREACC) + "1";
        String cdute = ExportHelper.fixedLength("1" + codicePdr, 17);
        String line = "%" + ExportHelper.fixedLength(codicePdr, 14) + cdute + segnale + this.dateFormat.format(data) + this.getFormattedValue(value) + ExportHelper.fixedLength(cdmeslet, 4) + CODICE_LETTURA + this.getFormattedValue(0.0) + ExportHelper.fixedLength(matricola, this.lunghezzaMatricola) + FLPREACC + FILLER + TAPPO;
        return line;
    }

    private String getFormattedValue(double value) {
        String string = this.decimalFormat.format(value);
        return String.valueOf(string.substring(0, 9)) + string.substring(10);
    }
}

