/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.services.consumi;

import biz.elabor.prebilling.gas.Funzionalita;
import biz.elabor.prebilling.gas.config.ConfigurationGasInstance;
import biz.elabor.prebilling.gas.services.GasStrategiesManager;
import biz.elabor.prebilling.gas.services.common.FileCopyStrategy;
import biz.elabor.prebilling.gas.services.consumi.ExportConsumiGas;
import biz.elabor.prebilling.gas.services.tariffe.GetSpreadStrategy;
import biz.elabor.prebilling.gas.web.AbstractGasStrategiesHandler;
import java.io.File;
import java.util.Date;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class ExportConsumiGasStrategiesHandler
extends AbstractGasStrategiesHandler {
    private final Date dataInizio;
    private final Date dataFine;
    private final String[] codiciPdr;
    private final String azienda;
    private final File outpuFolder;

    public ExportConsumiGasStrategiesHandler(Date dataInizio, Date dataFine, String[] codiciPdr, String azienda, File outpuFolder, ConfigurationGasInstance instanceConfiguration, TalkManager talkManager) {
        super(instanceConfiguration, talkManager);
        this.dataInizio = dataInizio;
        this.dataFine = dataFine;
        this.codiciPdr = codiciPdr;
        this.azienda = azienda;
        this.outpuFolder = outpuFolder;
    }

    @Override
    public GasStrategiesManager buildStrategiesManager() {
        GasStrategiesManager manager = new GasStrategiesManager(this.configuration);
        manager.addStrategy(new GetSpreadStrategy(this.misureDao));
        manager.addStrategy(new ExportConsumiGas(this.dataInizio, this.dataFine, this.codiciPdr, this.azienda, this.outpuFolder, this.giadaDao, this.misureDao, this.configuration, this.talkManager));
        manager.addStrategy(new FileCopyStrategy(Funzionalita.EXPORT_CONSUMI_GAS, this.configuration, this.talkManager));
        return manager;
    }
}

