/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.services.pcs;

import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.common.utils.MissingCodicePerseoException;
import biz.elabor.prebilling.gas.config.PrebillingGasConfiguration;
import biz.elabor.prebilling.gas.dao.giada.GiadaGasDao;
import biz.elabor.prebilling.gas.dao.misure.MisureGasDao;
import biz.elabor.prebilling.gas.dao.misure.model.Cliente;
import biz.elabor.prebilling.gas.dao.misure.model.ContrattoGas;
import biz.elabor.prebilling.gas.services.GasServiceStatus;
import biz.elabor.prebilling.gas.services.GasServiceStrategy;
import biz.elabor.prebilling.gas.services.common.DownloadPerseoHelper;
import biz.elabor.prebilling.gas.services.pcs.PcsAzienda;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.ListMap;

public class DownloadConsumiPcsStrategy
implements GasServiceStrategy {
    private final int anno;
    private final Month mese;
    private final MisureGasDao misureDao;
    private final GiadaGasDao giadaDao;
    private final PrebillingGasConfiguration configuration;
    private final TalkManager talkManager;

    public DownloadConsumiPcsStrategy(int anno, Month mese, MisureGasDao misureDao, GiadaGasDao giadaDao, PrebillingGasConfiguration configuration, TalkManager talkManager) {
        this.anno = anno;
        this.mese = mese;
        this.misureDao = misureDao;
        this.giadaDao = giadaDao;
        this.configuration = configuration;
        this.talkManager = talkManager;
    }

    @Override
    public boolean execute(GasServiceStatus status) {
        boolean ok;
        Date inizioMese = CalendarTools.getDate(this.anno, this.mese, 1);
        Date fineMese = CalendarTools.getEndDate(this.anno, this.mese);
        ListMap<String, ContrattoGas> mappaContratti = this.giadaDao.getContratti(inizioMese, "*", null, true);
        try {
            LinkedHashMap<String, PcsAzienda> pcsAziende = new LinkedHashMap<String, PcsAzienda>();
            String direttiBaseUrl = this.configuration.getDirettiBaseUrl();
            for (List list : mappaContratti) {
                HashSet<String> messagesSet = new HashSet<String>();
                Date prevStartDate = null;
                for (ContrattoGas contratto : list) {
                    String azienda = contratto.getReseller();
                    String remi = contratto.getCodiceRemi();
                    Cliente cliente = null;
                    Date dataValidita = contratto.getDataValidita();
                    Date startDate = CalendarTools.max(inizioMese, dataValidita);
                    if (startDate.equals(prevStartDate)) continue;
                    prevStartDate = startDate;
                    Date endDate = CalendarTools.minNullable(fineMese, contratto.getDataScadenza());
                    List<Cliente> clienti = this.misureDao.getClienti(remi, startDate, endDate);
                    try {
                        DownloadConsumiPcsStrategy.checkClienti(clienti, remi, startDate, endDate);
                        cliente = clienti.get(0);
                        Logger logger = status.getLogger();
                        List<Double> consumiRemi = DownloadPerseoHelper.downloadConsumi(cliente, this.anno, this.mese, direttiBaseUrl, logger);
                        List<Double> pcsRemi = DownloadPerseoHelper.downloadPcs(cliente, this.anno, this.mese, direttiBaseUrl, logger);
                        DownloadPerseoHelper.addPcs(azienda, cliente, consumiRemi, pcsRemi, pcsAziende);
                    }
                    catch (DataNotFoundException exc) {
                        String message = exc.getMessage();
                        Message sentence = new Message("pcs", message);
                        sentence.addParam(exc.getKey());
                        String userMessage = this.talkManager.getMessage(sentence);
                        if (!messagesSet.add(userMessage)) continue;
                        this.talkManager.addSentence(sentence);
                    }
                    catch (MissingCodicePerseoException exc) {
                        Message sentence = new Message("pcs", "perseo.error");
                        sentence.addParam(cliente == null ? "" : cliente.getCodicePdr());
                        sentence.addParam("/ " + azienda + " ");
                        sentence.addParam(exc.getAmbito());
                        this.talkManager.addSentence(sentence);
                    }
                }
            }
            status.setPcsAziende(pcsAziende);
            ok = true;
        }
        catch (IOException exc) {
            ok = false;
            Message sentence = new Message("pcs", "dwnl.failed");
            sentence.addParam(exc.toString());
            String string = this.talkManager.getMessage(sentence);
            Logger logger = status.getLogger();
            logger.log(Level.SEVERE, string, exc);
            this.talkManager.addSentence(sentence);
        }
        return ok;
    }

    private static void checkClienti(List<Cliente> clienti, String remi, Date startDate, Date endDate) throws DataNotFoundException {
        DateFormat standardDateFormat = StrategyCommonHelper.getStandardDateFormat();
        String startDateFmt = standardDateFormat.format(startDate);
        String endDateFmt = standardDateFormat.format(endDate);
        if (clienti.size() > 1) {
            String key = String.valueOf(remi) + " - " + startDateFmt + " / " + endDateFmt;
            throw new DataNotFoundException("remi.non.unico", key, -1);
        }
        if (clienti.isEmpty()) {
            String key = String.valueOf(remi) + " alla data " + startDateFmt;
            throw new DataNotFoundException("cliente.notfound", key, -1);
        }
    }
}

