/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.services.regime;

import biz.elabor.prebilling.common.FileCopyHelper;
import biz.elabor.prebilling.common.model.BasicContratto;
import biz.elabor.prebilling.common.model.RegimeContratto;
import biz.elabor.prebilling.common.utils.AbstractRegimeService;
import biz.elabor.prebilling.gas.Funzionalita;
import biz.elabor.prebilling.gas.config.ConfigurationHelper;
import biz.elabor.prebilling.gas.config.PrebillingGasConfiguration;
import biz.elabor.prebilling.gas.dao.giada.GiadaGasDao;
import biz.elabor.prebilling.gas.dao.misure.MisureGasDao;
import biz.elabor.prebilling.gas.dao.misure.model.ContrattoGas;
import biz.elabor.prebilling.gas.dao.misure.model.GasPdrRegime;
import biz.elabor.prebilling.gas.dao.misure.model.MisuraGas;
import biz.elabor.prebilling.gas.services.GasServiceStatus;
import biz.elabor.prebilling.gas.services.GasServiceStrategy;
import java.io.File;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class RegimeGasStrategy
extends AbstractRegimeService
implements GasServiceStrategy {
    private final String target;
    private final MisureGasDao misureDao;
    private final GiadaGasDao giadaDao;
    private final PrebillingGasConfiguration configuration;
    private final TalkManager talkManager;

    public RegimeGasStrategy(String target, MisureGasDao misureDao, GiadaGasDao giadaDao, PrebillingGasConfiguration configuration, TalkManager talkManager) {
        super("InizioTrattamentoGiornaliero");
        this.target = target;
        this.misureDao = misureDao;
        this.giadaDao = giadaDao;
        this.configuration = configuration;
        this.talkManager = talkManager;
    }

    @Override
    public boolean execute(GasServiceStatus status) {
        this.initRegime();
        this.handleDiretti(status);
        int idMax = this.handleIndiretti(status);
        boolean response = this.exportRegime("-gas-", this.target, status);
        if (response && idMax > 0) {
            Date today = this.configuration.getToDay();
            this.misureDao.updateDatiRegime(idMax, today);
        }
        return response;
    }

    private void handleDiretti(GasServiceStatus status) {
        Date today = this.configuration.getToDay();
        List<BasicContratto> contratti = this.misureDao.getContrattiDirettiNonRegime(today);
        for (BasicContratto contratto : contratti) {
            Date inizio = contratto.getDataInizio();
            this.fillRegime(contratto, inizio, status);
        }
    }

    public int handleIndiretti(GasServiceStatus status) {
        int idMax = 0;
        List<GasPdrRegime> gasPdrRegimeList = this.misureDao.getPdrRegime();
        for (GasPdrRegime gasPdrRegime : gasPdrRegimeList) {
            int idTgl = gasPdrRegime.getIdTgl();
            idMax = Math.max(idMax, idTgl);
            this.handlePdr(gasPdrRegime, status);
        }
        return idMax;
    }

    private void handlePdr(GasPdrRegime gasPdrRegime, GasServiceStatus status) {
        Date dataRegime;
        String pdr = gasPdrRegime.getCodicePdr();
        RegimeContratto contratto = this.misureDao.getContrattoValido(pdr, dataRegime = gasPdrRegime.getDataRegime());
        if (contratto == null) {
            String azienda = gasPdrRegime.getAzienda();
            this.fillRegime(azienda, pdr, dataRegime);
            status.count(azienda, "regime", 1);
        } else {
            this.handleContratto(contratto, status);
        }
    }

    private void handleContratto(RegimeContratto contratto, GasServiceStatus status) {
        Date dataRegime = contratto.getDataFirstRegime();
        String codicePdr = contratto.getCodice();
        if (dataRegime == null) {
            ContrattoGas contrattoGas;
            Date dataMisuraR;
            MisuraGas misuraP = this.misureDao.getFirstMisuraPeriodica(codicePdr, this.talkManager);
            MisuraGas misuraR = this.misureDao.getFirstMisuraRettifica(codicePdr, this.talkManager);
            Date dataMisuraP = RegimeGasStrategy.getData(misuraP);
            Date dataPrimaMisura = CalendarTools.minNullable(dataMisuraP, dataMisuraR = RegimeGasStrategy.getData(misuraR));
            if (dataPrimaMisura == null && (contrattoGas = this.giadaDao.getUltimoContratto(codicePdr)).isDiretto()) {
                dataPrimaMisura = contrattoGas.getDataInizio();
            }
            this.fillRegime(contratto, dataPrimaMisura, status);
        } else {
            Message sentence = new Message("regime", "pdr.regime");
            sentence.addParam(codicePdr);
            this.talkManager.addSentence(sentence);
        }
    }

    private static Date getData(MisuraGas misura) {
        return misura == null ? null : misura.getDataMisura();
    }

    @Override
    protected File getFolder(String idEsecuzione, String azienda, String targetStr) {
        File folder = targetStr.equalsIgnoreCase("file") ? ConfigurationHelper.getResellerTmpImportFolder(this.configuration, idEsecuzione, azienda, Funzionalita.REGIME_GAS) : FileCopyHelper.getResellerCodaTmpFolder(this.configuration, idEsecuzione, azienda);
        return folder;
    }

    @Override
    protected Date getDataRegime(Date dataPrimaMisura, Date dataInizio) {
        Date dataRegime;
        Date dataLimite = CalendarTools.nextDay(dataInizio);
        if (dataPrimaMisura.after(dataLimite)) {
            Date dataInizioMese = RegimeGasStrategy.getDataInizioMese(dataPrimaMisura);
            dataRegime = CalendarTools.max(dataInizioMese, dataInizio);
        } else {
            dataRegime = dataInizio;
        }
        return dataRegime;
    }
}

