/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.services.tariffe;

import biz.elabor.prebilling.InconsistentOptionException;
import biz.elabor.prebilling.gas.config.PrebillingGasConfiguration;
import biz.elabor.prebilling.gas.dao.misure.MisureGasDao;
import biz.elabor.prebilling.gas.services.GasServiceStatus;
import biz.elabor.prebilling.gas.services.GasServiceStrategy;
import biz.elabor.prebilling.gas.services.tariffe.DownloadPrezziService;
import java.io.IOException;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class DownloadPrezziGasPeriodo
implements GasServiceStrategy {
    private final int annoInizio;
    private final Month meseInizio;
    private final int annoFine;
    private final Month meseFine;
    private final String onlyIndice;
    private final boolean bloccoIndice;
    private final MisureGasDao misureDao;
    private final String prezziBaseUrl;
    private final TalkManager talkManager;

    public DownloadPrezziGasPeriodo(int annoInizio, Month meseInizio, int annoFine, Month meseFine, String onlyIndice, boolean bloccoIndice, MisureGasDao misureDao, PrebillingGasConfiguration configuration, TalkManager talkManager) {
        this.annoInizio = annoInizio;
        this.meseInizio = meseInizio;
        this.annoFine = annoFine;
        this.meseFine = meseFine;
        this.onlyIndice = onlyIndice;
        this.bloccoIndice = bloccoIndice;
        this.misureDao = misureDao;
        this.prezziBaseUrl = configuration.getPrezziBaseUrl();
        this.talkManager = talkManager;
    }

    @Override
    public boolean execute(GasServiceStatus status) {
        boolean ok;
        try {
            ElaborCalendar calendarStart = new ElaborCalendar(this.annoInizio, this.meseInizio);
            ElaborCalendar calendarEnd = new ElaborCalendar(this.annoFine, this.meseFine);
            while (!calendarStart.getDate().after(calendarEnd.getDate())) {
                int anno = calendarStart.getAnno();
                Month mese = calendarStart.getMese();
                DownloadPrezziService.downloadPrezzi(anno, mese, this.onlyIndice, this.prezziBaseUrl, this.bloccoIndice, this.misureDao, this.talkManager);
                calendarStart.addMesi(1);
            }
            ok = true;
        }
        catch (IOException exc) {
            ok = false;
            Message sentence = new Message("prezzi", "dwnl.failed");
            sentence.addParam(exc.toString());
            this.talkManager.addSentence(sentence);
            String userMessage = this.talkManager.getMessage(sentence);
            Logger logger = status.getLogger();
            logger.log(Level.SEVERE, userMessage, exc);
        }
        catch (ParseException exc) {
            ok = false;
            Message sentence = new Message("prezzi", "parse.errore");
            sentence.addParam(exc.toString());
            this.talkManager.addSentence(sentence);
            String userMessage = this.talkManager.getMessage(sentence);
            Logger logger = status.getLogger();
            logger.log(Level.SEVERE, userMessage, exc);
        }
        catch (DataNotFoundException exc) {
            ok = true;
            Message sentence = new Message("prezzi", exc.getMessage());
            this.talkManager.addSentence(sentence);
        }
        catch (InconsistentOptionException exc) {
            ok = true;
        }
        return ok;
    }
}

