/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.services.tariffe;

import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.common.model.Applicazione;
import biz.elabor.prebilling.common.utils.ExportHelper;
import biz.elabor.prebilling.gas.Funzionalita;
import biz.elabor.prebilling.gas.config.ConfigurationHelper;
import biz.elabor.prebilling.gas.config.PrebillingGasConfiguration;
import biz.elabor.prebilling.gas.services.GasServiceStatus;
import biz.elabor.prebilling.gas.services.GasServiceStrategy;
import biz.elabor.prebilling.gas.services.StrategyHelper;
import biz.elabor.prebilling.gas.services.tariffe.TariffeContratto;
import biz.elabor.prebilling.gas.services.tariffe.TariffePdr;
import biz.elabor.prebilling.gas.services.tariffe.TariffePdrData;
import biz.elabor.prebilling.gas.services.tariffe.model.DettaglioGiorno;
import biz.elabor.prebilling.gas.services.tariffe.model.TariffaGas;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.homelinux.elabor.text.Format;

public class ExportTariffeStrategy
implements GasServiceStrategy {
    private final PrebillingGasConfiguration configuration;
    private final Funzionalita funzionalita;
    private final DecimalFormat quattroFormat;
    private final DecimalFormat setteFormat;
    private final DecimalFormat dodiciFormat;
    private final DecimalFormat tariffaFormat;
    private final DecimalFormat prezzoFormat;
    private final DecimalFormat consumoFormat;
    private final DecimalFormat importoFormat;
    private final DecimalFormat pcsFormat;
    private final DateFormat dateFormat;
    private final DateFormat mediumDateFormat;
    private final DateFormat monthYearDateFormat;

    public ExportTariffeStrategy(Funzionalita funzionalita, PrebillingGasConfiguration configuration) {
        this.configuration = configuration;
        this.funzionalita = funzionalita;
        this.prezzoFormat = StrategyHelper.getPrezzoFormat();
        this.consumoFormat = StrategyHelper.getConsumoFormat();
        this.importoFormat = StrategyHelper.getImportoFormat();
        this.quattroFormat = StrategyHelper.getQuattroFormat();
        this.setteFormat = StrategyHelper.getSetteFormat();
        this.dodiciFormat = StrategyHelper.getDodiciFormat();
        this.pcsFormat = StrategyHelper.getPcsFormat();
        this.dateFormat = StrategyHelper.getShortDateFormat();
        this.mediumDateFormat = StrategyHelper.getMediumDateFormat();
        this.monthYearDateFormat = StrategyCommonHelper.getMeseAnnoDateFormat();
        this.tariffaFormat = Format.newDecimalFormat(Locale.ITALIAN, "000000.00000000+;000000.00000000-");
    }

    @Override
    public boolean execute(GasServiceStatus status) {
        boolean ok;
        Map<String, Map<String, Map<String, TariffePdr>>> tariffe = status.getTariffe();
        try {
            String idEsecuzione = status.getIdEsecuzione();
            for (Map.Entry<String, Map<String, Map<String, TariffePdr>>> entryAzienda : tariffe.entrySet()) {
                String azienda = entryAzienda.getKey();
                Map<String, Map<String, TariffePdr>> tariffeAzienda = entryAzienda.getValue();
                for (Map.Entry<String, Map<String, TariffePdr>> entryMese : tariffeAzienda.entrySet()) {
                    String annoMese = entryMese.getKey();
                    Map<String, TariffePdr> tariffeAziendaMese = entryMese.getValue();
                    this.printTariffeAziendaMese(idEsecuzione, azienda, annoMese, tariffeAziendaMese);
                }
            }
            ok = true;
        }
        catch (FileNotFoundException exc) {
            Logger logger = status.getLogger();
            logger.log(Level.SEVERE, "export tariffe", exc);
            ok = false;
        }
        return ok;
    }

    private void printDettaglioTariffePdr(String idEsecuzione, String azienda, String annoMese, String codicePdr, TariffePdr tariffePdr) throws FileNotFoundException {
        boolean multiple = tariffePdr.size() > 1;
        int count = 0;
        for (Map.Entry<Date, TariffePdrData> entryData : tariffePdr.entrySet()) {
            Date data = entryData.getKey();
            TariffePdrData tariffeData = entryData.getValue();
            String key = String.valueOf(codicePdr) + (multiple ? Character.valueOf((char)(65 + count)) : "");
            this.printDettaglioTariffeData(idEsecuzione, azienda, annoMese, codicePdr, data, key, tariffeData);
            ++count;
        }
    }

    private void printDettaglioTariffeData(String idEsecuzione, String azienda, String annoMese, String codicePdr, Date data, String key, TariffePdrData tariffeData) throws FileNotFoundException {
        if (tariffeData.hasDettagli()) {
            List<TariffeContratto> tariffe = tariffeData.getTariffe();
            File folder = ConfigurationHelper.getResellerTmpTariffeFolder(this.configuration, idEsecuzione, azienda, this.funzionalita, annoMese);
            DateFormat timestampFormat = StrategyHelper.getTimestampFormat();
            String timestamp = timestampFormat.format(new Date());
            String rettifica = tariffeData.isRettifica() ? "-R" : "";
            String fileName = String.valueOf(key) + "-" + annoMese + rettifica + "-" + timestamp + ".csv";
            File file = new File(folder, fileName);
            Throwable throwable = null;
            Object var16_17 = null;
            try (PrintWriter writer = new PrintWriter(file);){
                writer.println("PDR;" + codicePdr);
                String meseanno = this.monthYearDateFormat.format(data);
                writer.println("MESE COMPETENZA;" + meseanno);
                double consumoTotaleSingolo = tariffeData.getConsumoTotalePdr();
                writer.println("SOMMA CONSUMI;" + this.importoFormat.format(consumoTotaleSingolo));
                for (TariffeContratto tariffeContratto : tariffe) {
                    List<TariffaGas> tariffeApplicazioni = tariffeContratto.getTariffe();
                    for (TariffaGas tariffa : tariffeApplicazioni) {
                        double prezzo = tariffa.getValore();
                        this.printSommaDettaglio(writer, tariffa, prezzo);
                    }
                    TariffaGas penale = tariffeContratto.getPenale();
                    if (penale != null) {
                        double costoTotale = penale.getCostoTotale();
                        this.printSommaDettaglio(writer, penale, costoTotale);
                    }
                    if (tariffeApplicazioni.size() <= 1) continue;
                    writer.println();
                    Applicazione applicazione = tariffeContratto.getApplicazione();
                    int tipoApplicazione = applicazione.getTipo();
                    String consumo = this.prezzoFormat.format(tariffeContratto.getConsumoTotale());
                    writer.println("SOMMA CONSUMI " + tipoApplicazione + ";" + consumo);
                    String costoTotale = this.importoFormat.format(tariffeContratto.getCostoTotale());
                    writer.println("SOMMA IMPORTI GIORNALIERI " + tipoApplicazione + ";" + costoTotale);
                    String valore = this.prezzoFormat.format(tariffeContratto.getValore());
                    writer.println("PREZZO MEDIO PONDERATO " + tipoApplicazione + ";" + valore);
                }
                writer.println();
                writer.print("PDR;GIORNO;CONSUMO");
                for (TariffeContratto tariffeContratto : tariffe) {
                    for (TariffaGas tariffaApplicazione : tariffeContratto.getTariffe()) {
                        ExportTariffeStrategy.printTestataDettaglio(writer, tariffaApplicazione);
                    }
                    TariffaGas penale = tariffeContratto.getPenale();
                    ExportTariffeStrategy.printTestataDettaglio(writer, penale);
                }
                writer.println();
                int dayCount = 0;
                while (tariffeData.hasMoreData(dayCount)) {
                    boolean dayStart = true;
                    for (TariffeContratto tariffeContratto : tariffe) {
                        for (TariffaGas tariffaApplicazione : tariffeContratto.getTariffe()) {
                            dayStart = this.printRigaDettaglio(writer, codicePdr, dayCount, dayStart, tariffaApplicazione);
                        }
                        TariffaGas penale = tariffeContratto.getPenale();
                        this.printRigaDettaglio(writer, codicePdr, dayCount, dayStart, penale);
                    }
                    writer.println();
                    ++dayCount;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private boolean printRigaDettaglio(PrintWriter writer, String codicePdr, int dayCount, boolean dayStart, TariffaGas tariffaApplicazione) {
        List<DettaglioGiorno> dettagli;
        boolean retValue = dayStart;
        if (tariffaApplicazione != null && (dettagli = tariffaApplicazione.getDettagli()) != null && !dettagli.isEmpty()) {
            DettaglioGiorno dettaglio = dettagli.get(dayCount);
            if (dayStart) {
                writer.print(codicePdr);
                writer.print(";" + this.mediumDateFormat.format(dettaglio.getDataMisura()));
                writer.print(";" + this.consumoFormat.format(dettaglio.getConsumo()));
                retValue = false;
            }
            double prezzo = dettaglio.getPrezzo();
            double importo = dettaglio.getCosto();
            double consumoEfficace = dettaglio.getConsumoEfficace();
            writer.print(";" + this.prezzoFormat.format(consumoEfficace));
            writer.print(";" + this.prezzoFormat.format(prezzo));
            writer.print(";" + this.importoFormat.format(importo));
        }
        return retValue;
    }

    private static void printTestataDettaglio(PrintWriter writer, TariffaGas tariffaApplicazione) {
        List<DettaglioGiorno> dettagli;
        if (tariffaApplicazione != null && (dettagli = tariffaApplicazione.getDettagli()) != null && !dettagli.isEmpty()) {
            int tipoApplicazione = tariffaApplicazione.getTipoApplicazione();
            writer.print(";CONSUMO " + tipoApplicazione);
            writer.print(";PREZZO " + tipoApplicazione);
            writer.print(";IMPORTO GIORNALIERO " + tipoApplicazione);
        }
    }

    private void printSommaDettaglio(PrintWriter writer, TariffaGas tariffa, double prezzo) {
        int tipoApplicazione = tariffa.getTipoApplicazione();
        writer.println();
        String consumo = this.prezzoFormat.format(tariffa.getConsumoTotaleEfficace());
        writer.println("SOMMA CONSUMI " + tipoApplicazione + ";" + consumo);
        String costoTotale = this.importoFormat.format(tariffa.getCostoTotale());
        writer.println("SOMMA IMPORTI GIORNALIERI " + tipoApplicazione + ";" + costoTotale);
        String valore = this.prezzoFormat.format(prezzo);
        writer.println("PREZZO MEDIO PONDERATO " + tipoApplicazione + ";" + valore);
    }

    private void printTariffeAziendaMese(String idEsecuzione, String azienda, String annoMese, Map<String, TariffePdr> tariffeAziendaMese) throws FileNotFoundException {
        File folder = ConfigurationHelper.getResellerTmpImportFolder(this.configuration, idEsecuzione, azienda, this.funzionalita);
        DateFormat timestampFormat = StrategyHelper.getTimestampFormat();
        String timestamp = timestampFormat.format(new Date());
        String fileName = "gas-tariffe-" + azienda + "-" + annoMese + "-" + timestamp + ".csv";
        File outFile = new File(folder, fileName);
        Throwable throwable = null;
        Object var11_12 = null;
        try (PrintWriter writer = new PrintWriter(outFile);){
            writer.println("@4;PREZZI INDICIZZATI;.");
            for (Map.Entry<String, TariffePdr> entryPdr : tariffeAziendaMese.entrySet()) {
                String codicePdr = entryPdr.getKey();
                TariffePdr tariffePdr = entryPdr.getValue();
                for (Map.Entry<Date, TariffePdrData> entryPdrData : tariffePdr.entrySet()) {
                    TariffePdrData tariffePdrData = entryPdrData.getValue();
                    for (TariffeContratto tariffeContratto : tariffePdrData.getTariffe()) {
                        double valore = tariffeContratto.getValore();
                        Applicazione applicazione = tariffeContratto.getApplicazione();
                        int tipoApplicazione = applicazione.getTipo();
                        double qtmisura = tariffeContratto.getConsumoTariffa();
                        this.printTariffeContratto(tariffeContratto, tipoApplicazione, valore, qtmisura, writer);
                        TariffaGas penale = tariffeContratto.getPenale();
                        if (penale == null) continue;
                        tipoApplicazione = penale.getTipoApplicazione();
                        valore = penale.getCostoTotale();
                        this.printTariffeContratto(tariffeContratto, tipoApplicazione, valore, 0.0, writer);
                    }
                }
                this.printDettaglioTariffePdr(idEsecuzione, azienda, annoMese, codicePdr, tariffePdr);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void printTariffeContratto(TariffeContratto tariffeContratto, int tipoApplicazione, double valore, double qtmisura, PrintWriter writer) {
        Date dataInizio = tariffeContratto.getDataInizio();
        Date dataScadenza = tariffeContratto.getDataScadenza();
        Date dataRevoca = tariffeContratto.getDataRevoca();
        String codIndiceEnergetico = tariffeContratto.getCodIndiceEnergetico();
        String codIndiceApplicato = tariffeContratto.getCodIndiceApplicato();
        double inpcsAcquisto = tariffeContratto.getInpcsAcquisto();
        writer.print(";;;");
        writer.print(String.valueOf(this.dateFormat.format(dataInizio)) + ";");
        writer.print(String.valueOf(this.quattroFormat.format(tipoApplicazione)) + ";");
        writer.print(String.valueOf(ExportHelper.fixedLengthNum(codIndiceApplicato, 4)) + ";");
        writer.print("0;");
        writer.print(String.valueOf(this.tariffaFormat.format(valore)) + ";");
        writer.print(String.valueOf(this.tariffaFormat.format(0L)) + ";");
        writer.print(String.valueOf(this.tariffaFormat.format(0L)) + ";");
        writer.print(String.valueOf(dataScadenza == null ? "" : this.dateFormat.format(dataScadenza)) + ";");
        writer.print(String.valueOf(dataRevoca == null ? "" : this.dateFormat.format(dataRevoca)) + ";");
        String codicePdr = tariffeContratto.getCodicePdr();
        writer.print(String.valueOf(ExportHelper.fixedLength(codicePdr, 30)) + ";");
        double aqconsum = tariffeContratto.getAqconsum();
        writer.print(String.valueOf(this.setteFormat.format(aqconsum)) + ";");
        writer.print(String.valueOf(this.dodiciFormat.format(qtmisura)) + ";");
        writer.print(String.valueOf(ExportHelper.fixedLengthNum(codIndiceEnergetico, 4)) + ";");
        writer.print(String.valueOf(this.pcsFormat.format(inpcsAcquisto)) + ";");
        writer.println(".");
    }
}

