/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.services.tariffe;

import biz.elabor.prebilling.gas.services.tariffe.TariffeContratto;
import biz.elabor.prebilling.gas.services.tariffe.model.DettaglioGiorno;
import biz.elabor.prebilling.gas.services.tariffe.model.TariffaGas;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class TariffePdrData {
    private final List<TariffeContratto> tariffe = new ArrayList<TariffeContratto>();

    public boolean hasDettagli() {
        boolean hasDettagli = false;
        for (TariffeContratto tariffeContratto : this.tariffe) {
            TariffaGas penale;
            List<DettaglioGiorno> dettagli;
            List<TariffaGas> tariffeApplicazione = tariffeContratto.getTariffe();
            if (!tariffeApplicazione.isEmpty()) {
                TariffaGas tariffaApplicazione = tariffeApplicazione.get(0);
                dettagli = tariffaApplicazione.getDettagli();
                hasDettagli |= dettagli != null && !dettagli.isEmpty();
            }
            if ((penale = tariffeContratto.getPenale()) == null) continue;
            dettagli = penale.getDettagli();
            hasDettagli |= dettagli != null && !dettagli.isEmpty();
        }
        return hasDettagli;
    }

    public boolean isRettifica() {
        TariffeContratto tariffeContratto = this.tariffe.get(0);
        return tariffeContratto.isRettifica();
    }

    public List<TariffeContratto> getTariffe() {
        return this.tariffe;
    }

    public boolean hasMoreData(int dayCount) {
        boolean moreData = false;
        Iterator<TariffeContratto> iterTarData = this.tariffe.iterator();
        while (!moreData && iterTarData.hasNext()) {
            TariffeContratto tariffeContratto = iterTarData.next();
            Iterator<TariffaGas> iterTarContr = tariffeContratto.getTariffe().iterator();
            while (!moreData && iterTarContr.hasNext()) {
                TariffaGas tariffaApplicazione = iterTarContr.next();
                moreData = TariffePdrData.hasMoreData(tariffaApplicazione, dayCount);
            }
            TariffaGas penale = tariffeContratto.getPenale();
            moreData |= TariffePdrData.hasMoreData(penale, dayCount);
        }
        return moreData;
    }

    private static boolean hasMoreData(TariffaGas tariffaApplicazione, int dayCount) {
        List<DettaglioGiorno> dettagli;
        boolean moreData = false;
        if (tariffaApplicazione != null && (dettagli = tariffaApplicazione.getDettagli()) != null && !dettagli.isEmpty()) {
            moreData = dettagli.size() > dayCount;
        }
        return moreData;
    }

    public void add(TariffeContratto tariffaContratto) {
        this.tariffe.add(tariffaContratto);
    }

    public String getCodicePdr() {
        return this.tariffe.get(0).getCodicePdr();
    }

    public Date getDataInizio() {
        return this.tariffe.get(0).getDataInizio();
    }

    public boolean isScivolo() {
        return this.tariffe.get(0).isScivolo();
    }

    public double getConsumoTotalePdr() {
        return this.tariffe.get(0).getConsumoTotalePdr();
    }
}

