/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.utils;

import biz.elabor.prebilling.gas.dao.giada.GiadaGasDao;
import biz.elabor.prebilling.gas.utils.AnnualGasProfiler;
import biz.elabor.prebilling.gas.utils.GasProfileBuilder;
import java.util.HashMap;
import java.util.Map;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;

public class AnnualProfileBuilder
implements GasProfileBuilder {
    private final Map<String, AnnualGasProfiler> profileMap;
    private final GiadaGasDao giadaDao;

    public AnnualProfileBuilder(GiadaGasDao giadaDao) {
        this.giadaDao = giadaDao;
        this.profileMap = new HashMap<String, AnnualGasProfiler>();
    }

    @Override
    public AnnualGasProfiler getProfiler(String cdProPre, int anno, Month mese) {
        String key = String.valueOf(cdProPre) + "|" + anno + "|" + mese.name();
        AnnualGasProfiler profilatore = this.profileMap.get(key);
        if (profilatore == null) {
            try {
                profilatore = new AnnualGasProfiler(cdProPre, anno, mese, this.giadaDao);
            }
            catch (DataNotFoundException dataNotFoundException) {
                // empty catch block
            }
            this.profileMap.put(key, profilatore);
        }
        return profilatore;
    }
}

