/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.web;

import biz.elabor.prebilling.common.AbstractCommonRequestHandler;
import biz.elabor.prebilling.common.DefaultResults;
import biz.elabor.prebilling.gas.config.PrebillingGasConfiguration;
import biz.elabor.prebilling.gas.dao.misure.MisureGasDao;
import biz.elabor.prebilling.gas.services.GasServiceStatus;
import biz.elabor.prebilling.gas.services.GasStrategiesHandler;
import biz.elabor.prebilling.gas.services.GasStrategiesManager;
import biz.elabor.prebilling.util.Results;
import java.io.File;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.logging.Logger;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public abstract class AbstractGasRequestHandler
extends AbstractCommonRequestHandler {
    private final String servizio;

    protected abstract LinkedHashMap<String, Object> getParams();

    protected abstract String getReseller();

    public AbstractGasRequestHandler(String messageId, TalkManager talkManager) {
        super(messageId, talkManager);
        this.servizio = "G";
    }

    public Results handleRequest(GasStrategiesHandler handler, PrebillingGasConfiguration configuration, MisureGasDao misureDao) throws InvalidParameterValue {
        Date inizio = configuration.getToDay();
        GasStrategiesManager service = handler.buildStrategiesManager();
        String idEsecuzione = configuration.getIdEsecuzione("prebillinggas", misureDao);
        GasServiceStatus status = new GasServiceStatus(idEsecuzione);
        Logger logger = status.getLogger();
        handler.setLogger(logger);
        String reseller = this.getReseller();
        LinkedHashMap<String, Object> params = this.getParams();
        misureDao.insertRun(this.servizio, idEsecuzione, inizio, this.messageId, reseller, params);
        boolean ok = service.execute(status);
        this.handleResultMessage(ok);
        Date fine = configuration.getToDay();
        misureDao.updateRun(idEsecuzione, fine);
        File file = status.getFile();
        return new DefaultResults(status, file);
    }
}

