/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.web.pcs;

import biz.elabor.prebilling.gas.config.ConfigurationGasInstance;
import biz.elabor.prebilling.gas.config.PrebillingGasConfiguration;
import biz.elabor.prebilling.gas.dao.misure.MisureGasDao;
import biz.elabor.prebilling.gas.web.AbstractGasRequestHandler;
import biz.elabor.prebilling.gas.web.JsonGasRequestHandler;
import biz.elabor.prebilling.gas.web.pcs.PcsGasStrategiesHandler;
import biz.elabor.prebilling.util.JsonHelper;
import biz.elabor.prebilling.util.Results;
import java.util.LinkedHashMap;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;
import org.homelinux.elabor.springtools.web.controllers.ControllerHelper;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.tools.StringUtils;

public class PcsGasJsonPostHandler
extends AbstractGasRequestHandler
implements JsonGasRequestHandler {
    private final String annoTxt;
    private final String meseTxt;
    private final String target;

    public PcsGasJsonPostHandler(String annoTxt, String meseTxt, String target, TalkManager talkManager) {
        super("pcs", talkManager);
        this.annoTxt = annoTxt;
        this.meseTxt = meseTxt;
        this.target = StringUtils.isEmpty(target) ? "file" : target;
    }

    @Override
    public String handleRequest(ConfigurationGasInstance instance) throws InvalidParameterValue {
        int anno = ControllerHelper.checkInt("anno", this.annoTxt);
        Month mese = ControllerHelper.checkEnum("mese", this.meseTxt, Month.class);
        PrebillingGasConfiguration configuration = instance.getConfiguration();
        MisureGasDao misureDao = instance.getMisureDao();
        PcsGasStrategiesHandler pcsHandler = new PcsGasStrategiesHandler(anno, mese, this.target, instance, this.talkManager);
        Results results = this.handleRequest(pcsHandler, configuration, misureDao);
        return JsonHelper.buildMessage(configuration, results, this.talkManager);
    }

    @Override
    protected LinkedHashMap<String, Object> getParams() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("anno", this.annoTxt);
        params.put("mese", this.meseTxt);
        params.put("target", this.target);
        return params;
    }

    @Override
    protected String getReseller() {
        return null;
    }
}

