/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.web.ricalcolotariffe;

import biz.elabor.prebilling.gas.config.ConfigurationGasInstance;
import biz.elabor.prebilling.gas.config.PrebillingGasConfiguration;
import biz.elabor.prebilling.gas.dao.misure.MisureGasDao;
import biz.elabor.prebilling.gas.services.StrategyHelper;
import biz.elabor.prebilling.gas.web.AbstractGasRequestHandler;
import biz.elabor.prebilling.gas.web.JsonGasRequestHandler;
import biz.elabor.prebilling.gas.web.ricalcolotariffe.RicalcoloTariffeGasStrategiesHandler;
import biz.elabor.prebilling.util.JsonHelper;
import biz.elabor.prebilling.util.Results;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;
import org.homelinux.elabor.springtools.web.controllers.ControllerHelper;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class RicalcoloTariffeGasJsonPostHandler
extends AbstractGasRequestHandler
implements JsonGasRequestHandler {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("MM/yyyy");
    private final String inizio;
    private final String fine;
    private final List<String> pdrs;
    private final String reseller;
    private final boolean scivoloEnabled;
    private final boolean forceSopraSoglia;
    private final String esportaLettureStr;
    private final boolean bloccoIndice;

    public RicalcoloTariffeGasJsonPostHandler(String inizio, String fine, List<String> pdrs, String reseller, boolean scivoloEnabled, boolean forceSopraSoglia, String esportaLettureStr, boolean bloccoIndice, TalkManager talkManager) {
        super("ricalcolo.tariffe", talkManager);
        this.inizio = inizio;
        this.fine = fine;
        this.pdrs = pdrs;
        this.reseller = reseller;
        this.scivoloEnabled = scivoloEnabled;
        this.forceSopraSoglia = forceSopraSoglia;
        this.esportaLettureStr = esportaLettureStr;
        this.bloccoIndice = bloccoIndice;
    }

    @Override
    public String handleRequest(ConfigurationGasInstance instance) throws InvalidParameterValue {
        Date dataInizio = ControllerHelper.checkData("data_inizio", this.inizio, DATE_FORMAT);
        Date dataFine = ControllerHelper.checkData("data_fine", this.fine, DATE_FORMAT);
        boolean esportaLetture = StrategyHelper.checkEsportaLetture(this.esportaLettureStr);
        ControllerHelper.checkEmpty("pdr", this.pdrs);
        PrebillingGasConfiguration configuration = instance.getConfiguration();
        MisureGasDao misureDao = instance.getMisureDao();
        RicalcoloTariffeGasStrategiesHandler ricalcoloTariffeHandler = new RicalcoloTariffeGasStrategiesHandler(dataInizio, dataFine, this.pdrs, this.reseller, this.scivoloEnabled, this.forceSopraSoglia, esportaLetture, this.bloccoIndice, instance, this.talkManager);
        Results results = this.handleRequest(ricalcoloTariffeHandler, configuration, misureDao);
        return JsonHelper.buildMessage(configuration, results, this.talkManager);
    }

    @Override
    protected LinkedHashMap<String, Object> getParams() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("inizo", this.inizio);
        params.put("fine", this.fine);
        params.put("pdr", this.pdrs.subList(0, Math.min(10, this.pdrs.size())));
        params.put("scivolo", this.scivoloEnabled);
        params.put("forzatura_consumo", this.forceSopraSoglia);
        params.put("letture", this.esportaLettureStr);
        return params;
    }

    @Override
    protected String getReseller() {
        return this.reseller;
    }
}

