/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.test;

import biz.elabor.prebilling.gas.config.ConfigurationGasInstance;
import biz.elabor.prebilling.gas.config.DefaultConfigurationGasInstance;
import biz.elabor.prebilling.gas.config.FileGasConfiguration;
import biz.elabor.prebilling.gas.config.PrebillingGasConfiguration;
import biz.elabor.prebilling.gas.web.JsonGasRequestHandler;
import biz.elabor.prebilling.test.AbstractPrebillingTest;
import biz.elabor.prebilling.test.Names;
import biz.elabor.prebilling.test.TestGasInitialiser;
import biz.elabor.prebilling.test.TestGiadaDao;
import biz.elabor.prebilling.test.TestInvalidParameterValue;
import biz.elabor.prebilling.test.TestMisureDao;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import org.homelinux.elabor.db.DbmsType;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class PrebillingGasTest
extends AbstractPrebillingTest {
    private PrebillingGasConfiguration configuration;
    private TestMisureDao misureDao;
    private TestGiadaDao giadaDao;

    @Override
    protected void closeTest() {
        if (this.misureDao != null) {
            this.misureDao.close();
        }
        if (this.giadaDao != null) {
            this.giadaDao.close();
        }
    }

    @Override
    protected String performTest() throws TestInvalidParameterValue {
        String result;
        ConfigurationGasInstance configurationInstance = this.buildConfigurationInstance();
        try {
            JsonGasRequestHandler handler = PrebillingGasTest.buildHandler(configurationInstance);
            result = handler.handleRequest(configurationInstance);
        }
        catch (Exception exc) {
            throw new TestInvalidParameterValue(exc);
        }
        return result;
    }

    private static JsonGasRequestHandler buildHandler(ConfigurationGasInstance configurationInstance) throws IOException, ParseException {
        File initFile = new File(testFolder, "init.csv");
        String[] params = PrebillingGasTest.loadParams(initFile);
        TestGasInitialiser initialiser = TestGasInitialiser.valueOf(params[0].trim().toUpperCase());
        params = Arrays.copyOfRange(params, 1, params.length);
        TalkManager talkManager = PrebillingGasTest.buildTalkManager();
        return initialiser.loadHandler(params, configurationInstance, talkManager);
    }

    private ConfigurationGasInstance buildConfigurationInstance() {
        return new DefaultConfigurationGasInstance(this.misureDao, this.giadaDao, this.configuration);
    }

    private void initDatabase(DbmsType dbType) throws IOException, SQLException, ParseException {
        this.clearDatabase();
        System.out.println("database cleared");
        File inputFolder = new File(testFolder, "input");
        PrebillingGasTest.importFiles(inputFolder, Names.GIADA_NAMES, this.giadaDao, dbType);
        PrebillingGasTest.importFiles(inputFolder, Names.MISURE_NAMES, this.misureDao, dbType);
    }

    private void clearDatabase() throws SQLException {
        PrebillingGasTest.clearDatabase(Names.GIADA_NAMES, this.misureDao);
        PrebillingGasTest.clearDatabase(Names.MISURE_NAMES, this.misureDao);
    }

    @Override
    protected void dumpDatabase(File dumpFolder) throws FileNotFoundException, SQLException {
        dumpFolder.mkdirs();
        PrebillingGasTest.dumpFiles(dumpFolder, Names.MISURE_NAMES, this.misureDao);
    }

    @Override
    protected void openTest(List<File> configFiles) throws InvalidPropertiesFormatException, IOException, SQLException, ParseException {
        this.configuration = new FileGasConfiguration(testFolder, configFiles, "test");
        DbmsType dbType = this.configuration.getMisureType();
        this.misureDao = new TestMisureDao(this.configuration);
        this.giadaDao = new TestGiadaDao(this.configuration);
        this.initDatabase(dbType);
    }
}

