/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.test;

import biz.elabor.prebilling.test.AbstractPrebillingTest;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.homelinux.elabor.file.PatternFileFilter;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;

public abstract class PrebillingTestMain {
    private static final List<Character> YES = Arrays.asList(Character.valueOf('y'), Character.valueOf('s'), Character.valueOf('1'));
    private final String defaultFolderName;

    protected abstract Class<?> getTestClass();

    public PrebillingTestMain(String defaultFolderName) {
        this.defaultFolderName = defaultFolderName;
    }

    public void run(String[] args) {
        long start = System.currentTimeMillis();
        List<String> failedTests = null;
        switch (args.length) {
            case 0: {
                File parent = new File(this.defaultFolderName);
                failedTests = this.launchTests(parent, "");
                break;
            }
            case 1: {
                failedTests = this.launchTest(new File(args[0]));
                break;
            }
            case 2: {
                boolean follow = YES.contains(Character.valueOf(args[1].toLowerCase().charAt(0)));
                File testFolder = new File(args[0]);
                if (follow) {
                    File parent = testFolder.getParentFile();
                    String name = testFolder.getName();
                    failedTests = this.launchTests(parent, name);
                    break;
                }
                failedTests = this.launchTest(testFolder);
                break;
            }
            default: {
                System.out.println("l'unico parametro ammesso \u00e8 la cartella di test");
            }
        }
        if (failedTests != null) {
            if (failedTests.isEmpty()) {
                System.out.println("It's all OK, folks!");
            } else {
                System.out.println("Ci sono " + failedTests.size() + " test falliti:");
                for (String failure : failedTests) {
                    System.out.print("\t");
                    System.out.println(failure);
                }
            }
        }
        double duration = (System.currentTimeMillis() - start) / 1000L;
        System.out.println("total elapsed time: " + duration + " seconds");
    }

    private List<String> launchTests(File folder, String start) {
        ArrayList<String> failedTests = new ArrayList<String>();
        if (folder.exists()) {
            PatternFileFilter filter = new PatternFileFilter("test-(.*)", "test folder filter");
            Object[] testFolders = folder.listFiles(filter);
            Arrays.sort(testFolders);
            Object[] objectArray = testFolders;
            int n2 = testFolders.length;
            int n3 = 0;
            while (n3 < n2) {
                Object testFolder = objectArray[n3];
                String testFolderName = ((File)testFolder).getName();
                if (testFolderName.compareTo(start) >= 0) {
                    List<String> testList = this.launchTest((File)testFolder);
                    failedTests.addAll(testList);
                }
                ++n3;
            }
            System.err.flush();
            System.out.println("eseguiti " + testFolders.length + " test");
            System.out.flush();
        } else {
            System.out.println("non esiste la cartella " + folder.getAbsolutePath());
        }
        return failedTests;
    }

    private List<String> launchTest(File testFolder) {
        File initFile = new File(testFolder, "init.csv");
        ArrayList<String> failedTests = new ArrayList<String>();
        if (initFile.exists()) {
            System.out.println("============ inizio: " + testFolder.getName());
            AbstractPrebillingTest.initTest(testFolder);
            JUnitCore junit = new JUnitCore();
            junit.addListener(new TextListener(System.out));
            Class<?> prebillingTestClass = this.getTestClass();
            Result result = junit.run(prebillingTestClass);
            failedTests.addAll(PrebillingTestMain.printResult(result, testFolder));
            System.out.println("============ fine: " + testFolder.getName());
        }
        return failedTests;
    }

    private static List<String> printResult(Result result, File testFolder) {
        ArrayList<String> testNames = new ArrayList<String>();
        List<Failure> failures = result.getFailures();
        for (Failure failure : failures) {
            String folderName = testFolder.getName();
            Throwable exception = failure.getException();
            exception.printStackTrace();
            System.out.println("fallimento: " + folderName);
            testNames.add(folderName);
        }
        return testNames;
    }
}

