/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.util;

import biz.elabor.prebilling.common.config.BasicPrebillingConfiguration;
import biz.elabor.prebilling.util.MessageExtractor;
import biz.elabor.prebilling.util.Results;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.homelinux.elabor.json.JsonTools;
import org.homelinux.elabor.springtools.web.widgets.Sentence;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.StructuresHelper;

public class JsonHelper {
    private JsonHelper() {
    }

    public static String buildMessage(BasicPrebillingConfiguration configuration, Results results, TalkManager talkManager) {
        return JsonHelper.buildMessage(configuration, null, results, talkManager);
    }

    public static String buildMessage(BasicPrebillingConfiguration configuration, String value, Results results, TalkManager talkManager) {
        List<Sentence> sentences = talkManager.getSentences();
        File file = results == null ? null : results.getFile();
        return JsonHelper.buildMessage(configuration, value, sentences, results, file, talkManager);
    }

    public static String buildMessage(BasicPrebillingConfiguration configuration, Results results, File file, TalkManager talkManager) {
        List<Sentence> sentences = talkManager.getSentences();
        return JsonHelper.buildMessage(configuration, null, sentences, results, file, talkManager);
    }

    private static String buildMessage(BasicPrebillingConfiguration configuration, String value, List<Sentence> sentences, Results results, File file, TalkManager talkManager) {
        String version;
        LinkedHashMap<String, Object> message = new LinkedHashMap<String, Object>();
        String string = version = configuration == null ? "sconosciuta" : configuration.getVersion();
        if (version != null) {
            message.put("version", version);
        }
        if (value != null) {
            message.put("value", value);
        }
        if (file != null) {
            message.put("file", file.getName());
        }
        if (results != null) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            results.putResults(map);
            if (!map.isEmpty()) {
                message.put("results", map);
            }
        }
        if (sentences != null && !sentences.isEmpty()) {
            ArrayList messages = new ArrayList();
            MessageExtractor extractor = new MessageExtractor(talkManager);
            StructuresHelper.buildCollection(messages, sentences, extractor);
            message.put("messages", messages);
        }
        return JsonTools.toJson(message);
    }
}

