/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.JetFormat;
import com.healthmarketscience.jackcess.UsageMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PageChannel
implements Channel {
    private static final Log LOG = LogFactory.getLog(PageChannel.class);
    private static final int PAGE_GLOBAL_USAGE_MAP = 1;
    private FileChannel _channel;
    private JetFormat _format;
    private UsageMap _globalUsageMap;

    public PageChannel(FileChannel channel, JetFormat format) throws IOException {
        this._channel = channel;
        this._format = format;
        if (channel != null) {
            this._globalUsageMap = UsageMap.read(this, 1, (byte)0, format);
        }
    }

    public boolean readPage(ByteBuffer buffer, int pageNumber) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading in page " + Integer.toHexString(pageNumber));
        }
        buffer.clear();
        boolean rtn = this._channel.read(buffer, (long)pageNumber * (long)this._format.PAGE_SIZE) != -1;
        buffer.flip();
        return rtn;
    }

    public void writePage(ByteBuffer page, int pageNumber) throws IOException {
        page.rewind();
        this._channel.write(page, (long)pageNumber * (long)this._format.PAGE_SIZE);
        this._channel.force(true);
    }

    public int writeNewPage(ByteBuffer page) throws IOException {
        long size = this._channel.size();
        page.rewind();
        this._channel.write(page, size);
        int pageNumber = (int)(size / (long)this._format.PAGE_SIZE);
        this._globalUsageMap.removePageNumber(pageNumber);
        return pageNumber;
    }

    public int getPageCount() throws IOException {
        return (int)(this._channel.size() / (long)this._format.PAGE_SIZE);
    }

    public ByteBuffer createPageBuffer() {
        ByteBuffer rtn = ByteBuffer.allocate(this._format.PAGE_SIZE);
        rtn.order(ByteOrder.LITTLE_ENDIAN);
        return rtn;
    }

    public void close() throws IOException {
        this._channel.force(true);
        this._channel.close();
    }

    public boolean isOpen() {
        return this._channel.isOpen();
    }
}

