/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import jxl.biff.IntegerHelper;
import jxl.biff.WritableRecordData;
import jxl.common.Logger;
import jxl.read.biff.Record;

public class ConditionalFormatRangeRecord
extends WritableRecordData {
    private static Logger logger = Logger.getLogger(ConditionalFormatRangeRecord.class);
    private Range enclosingRange;
    private Range[] ranges;
    private int numRanges;
    private boolean initialized = false;
    private boolean modified = false;
    private byte[] data = this.getRecord().getData();

    public ConditionalFormatRangeRecord(Record t) {
        super(t);
    }

    private void initialize() {
        this.enclosingRange = new Range();
        this.enclosingRange.firstRow = IntegerHelper.getInt(this.data[4], this.data[5]);
        this.enclosingRange.lastRow = IntegerHelper.getInt(this.data[6], this.data[7]);
        this.enclosingRange.firstColumn = IntegerHelper.getInt(this.data[8], this.data[9]);
        this.enclosingRange.lastColumn = IntegerHelper.getInt(this.data[10], this.data[11]);
        this.numRanges = IntegerHelper.getInt(this.data[12], this.data[13]);
        this.ranges = new Range[this.numRanges];
        int pos = 14;
        for (int i2 = 0; i2 < this.numRanges; ++i2) {
            this.ranges[i2] = new Range();
            this.ranges[i2].firstRow = IntegerHelper.getInt(this.data[pos], this.data[pos + 1]);
            this.ranges[i2].lastRow = IntegerHelper.getInt(this.data[pos + 2], this.data[pos + 3]);
            this.ranges[i2].firstColumn = IntegerHelper.getInt(this.data[pos + 4], this.data[pos + 5]);
            this.ranges[i2].lastColumn = IntegerHelper.getInt(this.data[pos + 6], this.data[pos + 7]);
            pos += 8;
        }
        this.initialized = true;
    }

    public void insertColumn(int col) {
        if (!this.initialized) {
            this.initialize();
        }
        this.enclosingRange.insertColumn(col);
        if (this.enclosingRange.modified) {
            this.modified = true;
        }
        for (int i2 = 0; i2 < this.ranges.length; ++i2) {
            this.ranges[i2].insertColumn(col);
            if (!this.ranges[i2].modified) continue;
            this.modified = true;
        }
    }

    public void removeColumn(int col) {
        if (!this.initialized) {
            this.initialize();
        }
        this.enclosingRange.removeColumn(col);
        if (this.enclosingRange.modified) {
            this.modified = true;
        }
        for (int i2 = 0; i2 < this.ranges.length; ++i2) {
            this.ranges[i2].removeColumn(col);
            if (!this.ranges[i2].modified) continue;
            this.modified = true;
        }
    }

    public void removeRow(int row) {
        if (!this.initialized) {
            this.initialize();
        }
        this.enclosingRange.removeRow(row);
        if (this.enclosingRange.modified) {
            this.modified = true;
        }
        for (int i2 = 0; i2 < this.ranges.length; ++i2) {
            this.ranges[i2].removeRow(row);
            if (!this.ranges[i2].modified) continue;
            this.modified = true;
        }
    }

    public void insertRow(int row) {
        if (!this.initialized) {
            this.initialize();
        }
        this.enclosingRange.insertRow(row);
        if (this.enclosingRange.modified) {
            this.modified = true;
        }
        for (int i2 = 0; i2 < this.ranges.length; ++i2) {
            this.ranges[i2].insertRow(row);
            if (!this.ranges[i2].modified) continue;
            this.modified = true;
        }
    }

    @Override
    public byte[] getData() {
        if (!this.modified) {
            return this.data;
        }
        byte[] d2 = new byte[14 + this.ranges.length * 8];
        System.arraycopy(this.data, 0, d2, 0, 4);
        IntegerHelper.getTwoBytes(this.enclosingRange.firstRow, d2, 4);
        IntegerHelper.getTwoBytes(this.enclosingRange.lastRow, d2, 6);
        IntegerHelper.getTwoBytes(this.enclosingRange.firstColumn, d2, 8);
        IntegerHelper.getTwoBytes(this.enclosingRange.lastColumn, d2, 10);
        IntegerHelper.getTwoBytes(this.numRanges, d2, 12);
        int pos = 14;
        for (int i2 = 0; i2 < this.ranges.length; ++i2) {
            IntegerHelper.getTwoBytes(this.ranges[i2].firstRow, d2, pos);
            IntegerHelper.getTwoBytes(this.ranges[i2].lastRow, d2, pos + 2);
            IntegerHelper.getTwoBytes(this.ranges[i2].firstColumn, d2, pos + 4);
            IntegerHelper.getTwoBytes(this.ranges[i2].lastColumn, d2, pos + 6);
            pos += 8;
        }
        return d2;
    }

    private static class Range {
        public int firstRow;
        public int firstColumn;
        public int lastRow;
        public int lastColumn;
        public boolean modified = false;

        public void insertColumn(int col) {
            if (col > this.lastColumn) {
                return;
            }
            if (col <= this.firstColumn) {
                ++this.firstColumn;
                this.modified = true;
            }
            if (col <= this.lastColumn) {
                ++this.lastColumn;
                this.modified = true;
            }
        }

        public void removeColumn(int col) {
            if (col > this.lastColumn) {
                return;
            }
            if (col < this.firstColumn) {
                --this.firstColumn;
                this.modified = true;
            }
            if (col <= this.lastColumn) {
                --this.lastColumn;
                this.modified = true;
            }
        }

        public void removeRow(int row) {
            if (row > this.lastRow) {
                return;
            }
            if (row < this.firstRow) {
                --this.firstRow;
                this.modified = true;
            }
            if (row <= this.lastRow) {
                --this.lastRow;
                this.modified = true;
            }
        }

        public void insertRow(int row) {
            if (row > this.lastRow) {
                return;
            }
            if (row <= this.firstRow) {
                ++this.firstRow;
                this.modified = true;
            }
            if (row <= this.lastRow) {
                ++this.lastRow;
                this.modified = true;
            }
        }
    }
}

