/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.WorkbookSettings;
import jxl.biff.DValParser;
import jxl.biff.DataValidityListRecord;
import jxl.biff.DataValiditySettingsRecord;
import jxl.biff.WorkbookMethods;
import jxl.biff.formula.ExternalSheet;
import jxl.common.Assert;
import jxl.common.Logger;
import jxl.write.biff.File;

public class DataValidation {
    private static Logger logger = Logger.getLogger(DataValidation.class);
    private DataValidityListRecord validityList;
    private ArrayList validitySettings;
    private WorkbookMethods workbook;
    private ExternalSheet externalSheet;
    private WorkbookSettings workbookSettings;
    private int comboBoxObjectId;
    private boolean copied;
    public static final int DEFAULT_OBJECT_ID = -1;
    private static final int MAX_NO_OF_VALIDITY_SETTINGS = 65533;

    public DataValidation(DataValidityListRecord dvlr) {
        this.validityList = dvlr;
        this.validitySettings = new ArrayList(this.validityList.getNumberOfSettings());
        this.copied = false;
    }

    public DataValidation(int objId, ExternalSheet es, WorkbookMethods wm, WorkbookSettings ws) {
        this.workbook = wm;
        this.externalSheet = es;
        this.workbookSettings = ws;
        this.validitySettings = new ArrayList();
        this.comboBoxObjectId = objId;
        this.copied = false;
    }

    public DataValidation(DataValidation dv, ExternalSheet es, WorkbookMethods wm, WorkbookSettings ws) {
        this.workbook = wm;
        this.externalSheet = es;
        this.workbookSettings = ws;
        this.copied = true;
        this.validityList = new DataValidityListRecord(dv.getDataValidityList());
        this.validitySettings = new ArrayList();
        DataValiditySettingsRecord[] settings = dv.getDataValiditySettings();
        for (int i2 = 0; i2 < settings.length; ++i2) {
            this.validitySettings.add(new DataValiditySettingsRecord(settings[i2], this.externalSheet, this.workbook, this.workbookSettings));
        }
    }

    public void add(DataValiditySettingsRecord dvsr) {
        this.validitySettings.add(dvsr);
        dvsr.setDataValidation(this);
        if (this.copied) {
            Assert.verify(this.validityList != null);
            this.validityList.dvAdded();
        }
    }

    public DataValidityListRecord getDataValidityList() {
        return this.validityList;
    }

    public DataValiditySettingsRecord[] getDataValiditySettings() {
        DataValiditySettingsRecord[] dvlr = new DataValiditySettingsRecord[]{};
        return this.validitySettings.toArray(dvlr);
    }

    public void write(File outputFile) throws IOException {
        if (this.validitySettings.size() > 65533) {
            logger.warn("Maximum number of data validations exceeded - truncating...");
            this.validitySettings = new ArrayList(this.validitySettings.subList(0, 65532));
            Assert.verify(this.validitySettings.size() <= 65533);
        }
        if (this.validityList == null) {
            DValParser dvp = new DValParser(this.comboBoxObjectId, this.validitySettings.size());
            this.validityList = new DataValidityListRecord(dvp);
        }
        if (!this.validityList.hasDVRecords()) {
            return;
        }
        outputFile.write(this.validityList);
        for (DataValiditySettingsRecord dvsr : this.validitySettings) {
            outputFile.write(dvsr);
        }
    }

    public void insertRow(int row) {
        for (DataValiditySettingsRecord dv : this.validitySettings) {
            dv.insertRow(row);
        }
    }

    public void removeRow(int row) {
        Iterator i2 = this.validitySettings.iterator();
        while (i2.hasNext()) {
            DataValiditySettingsRecord dv = (DataValiditySettingsRecord)i2.next();
            if (dv.getFirstRow() == row && dv.getLastRow() == row) {
                i2.remove();
                this.validityList.dvRemoved();
                continue;
            }
            dv.removeRow(row);
        }
    }

    public void insertColumn(int col) {
        for (DataValiditySettingsRecord dv : this.validitySettings) {
            dv.insertColumn(col);
        }
    }

    public void removeColumn(int col) {
        Iterator i2 = this.validitySettings.iterator();
        while (i2.hasNext()) {
            DataValiditySettingsRecord dv = (DataValiditySettingsRecord)i2.next();
            if (dv.getFirstColumn() == col && dv.getLastColumn() == col) {
                i2.remove();
                this.validityList.dvRemoved();
                continue;
            }
            dv.removeColumn(col);
        }
    }

    public void removeDataValidation(int col, int row) {
        Iterator i2 = this.validitySettings.iterator();
        while (i2.hasNext()) {
            DataValiditySettingsRecord dv = (DataValiditySettingsRecord)i2.next();
            if (dv.getFirstColumn() != col || dv.getLastColumn() != col || dv.getFirstRow() != row || dv.getLastRow() != row) continue;
            i2.remove();
            this.validityList.dvRemoved();
            break;
        }
    }

    public void removeSharedDataValidation(int col1, int row1, int col2, int row2) {
        Iterator i2 = this.validitySettings.iterator();
        while (i2.hasNext()) {
            DataValiditySettingsRecord dv = (DataValiditySettingsRecord)i2.next();
            if (dv.getFirstColumn() != col1 || dv.getLastColumn() != col2 || dv.getFirstRow() != row1 || dv.getLastRow() != row2) continue;
            i2.remove();
            this.validityList.dvRemoved();
            break;
        }
    }

    public DataValiditySettingsRecord getDataValiditySettings(int col, int row) {
        boolean found = false;
        DataValiditySettingsRecord foundRecord = null;
        Iterator i2 = this.validitySettings.iterator();
        while (i2.hasNext() && !found) {
            DataValiditySettingsRecord dvsr = (DataValiditySettingsRecord)i2.next();
            if (dvsr.getFirstColumn() != col || dvsr.getFirstRow() != row) continue;
            found = true;
            foundRecord = dvsr;
        }
        return foundRecord;
    }

    public int getComboBoxObjectId() {
        return this.comboBoxObjectId;
    }
}

