/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.format.Colour;
import jxl.format.RGB;
import jxl.read.biff.Record;

public class PaletteRecord
extends WritableRecordData {
    private RGB[] rgbColours = new RGB[56];
    private boolean dirty;
    private boolean read;
    private boolean initialized;
    private static final int numColours = 56;

    public PaletteRecord(Record t) {
        super(t);
        this.initialized = false;
        this.dirty = false;
        this.read = true;
    }

    public PaletteRecord() {
        super(Type.PALETTE);
        this.initialized = true;
        this.dirty = false;
        this.read = false;
        Colour[] colours = Colour.getAllColours();
        for (int i2 = 0; i2 < colours.length; ++i2) {
            Colour c2 = colours[i2];
            this.setColourRGB(c2, c2.getDefaultRGB().getRed(), c2.getDefaultRGB().getGreen(), c2.getDefaultRGB().getBlue());
        }
    }

    @Override
    public byte[] getData() {
        if (this.read && !this.dirty) {
            return this.getRecord().getData();
        }
        byte[] data = new byte[226];
        int pos = 0;
        IntegerHelper.getTwoBytes(56, data, pos);
        for (int i2 = 0; i2 < 56; ++i2) {
            pos = i2 * 4 + 2;
            data[pos] = (byte)this.rgbColours[i2].getRed();
            data[pos + 1] = (byte)this.rgbColours[i2].getGreen();
            data[pos + 2] = (byte)this.rgbColours[i2].getBlue();
        }
        return data;
    }

    private void initialize() {
        byte[] data = this.getRecord().getData();
        int numrecords = IntegerHelper.getInt(data[0], data[1]);
        for (int i2 = 0; i2 < numrecords; ++i2) {
            int pos = i2 * 4 + 2;
            int red = IntegerHelper.getInt(data[pos], (byte)0);
            int green = IntegerHelper.getInt(data[pos + 1], (byte)0);
            int blue = IntegerHelper.getInt(data[pos + 2], (byte)0);
            this.rgbColours[i2] = new RGB(red, green, blue);
        }
        this.initialized = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setColourRGB(Colour c2, int r2, int g2, int b2) {
        int pos = c2.getValue() - 8;
        if (pos < 0 || pos >= 56) {
            return;
        }
        if (!this.initialized) {
            this.initialize();
        }
        r2 = this.setValueRange(r2, 0, 255);
        g2 = this.setValueRange(g2, 0, 255);
        b2 = this.setValueRange(b2, 0, 255);
        this.rgbColours[pos] = new RGB(r2, g2, b2);
        this.dirty = true;
    }

    public RGB getColourRGB(Colour c2) {
        int pos = c2.getValue() - 8;
        if (pos < 0 || pos >= 56) {
            return c2.getDefaultRGB();
        }
        if (!this.initialized) {
            this.initialize();
        }
        return this.rgbColours[pos];
    }

    private int setValueRange(int val, int min, int max) {
        val = Math.max(val, min);
        val = Math.min(val, max);
        return val;
    }
}

