/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import jxl.biff.drawing.EscherRecordData;
import jxl.biff.drawing.EscherRecordType;
import jxl.biff.drawing.EscherStream;
import jxl.common.Logger;

abstract class EscherRecord {
    private static Logger logger = Logger.getLogger(EscherRecord.class);
    private EscherRecordData data;
    protected static final int HEADER_LENGTH = 8;

    protected EscherRecord(EscherRecordData erd) {
        this.data = erd;
    }

    protected EscherRecord(EscherRecordType type) {
        this.data = new EscherRecordData(type);
    }

    protected void setContainer(boolean cont) {
        this.data.setContainer(cont);
    }

    public int getLength() {
        return this.data.getLength() + 8;
    }

    protected final EscherStream getEscherStream() {
        return this.data.getEscherStream();
    }

    protected final int getPos() {
        return this.data.getPos();
    }

    protected final int getInstance() {
        return this.data.getInstance();
    }

    protected final void setInstance(int i2) {
        this.data.setInstance(i2);
    }

    protected final void setVersion(int v) {
        this.data.setVersion(v);
    }

    public EscherRecordType getType() {
        return this.data.getType();
    }

    abstract byte[] getData();

    final byte[] setHeaderData(byte[] d2) {
        return this.data.setHeaderData(d2);
    }

    byte[] getBytes() {
        return this.data.getBytes();
    }

    protected int getStreamLength() {
        return this.data.getStreamLength();
    }

    protected EscherRecordData getEscherData() {
        return this.data;
    }
}

