/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto;

import java.security.SecureRandom;
import net.lingala.zip4j.crypto.Encrypter;
import net.lingala.zip4j.crypto.engine.ZipCryptoEngine;
import net.lingala.zip4j.exception.ZipException;

public class StandardEncrypter
implements Encrypter {
    private ZipCryptoEngine zipCryptoEngine = new ZipCryptoEngine();
    private byte[] headerBytes = new byte[12];

    public StandardEncrypter(char[] password, long key) throws ZipException {
        this.init(password, key);
    }

    private void init(char[] password, long key) throws ZipException {
        if (password == null || password.length <= 0) {
            throw new ZipException("input password is null or empty, cannot initialize standard encrypter");
        }
        this.zipCryptoEngine.initKeys(password);
        this.headerBytes = this.generateRandomBytes(12);
        this.zipCryptoEngine.initKeys(password);
        this.headerBytes[11] = (byte)(key >>> 24);
        this.headerBytes[10] = (byte)(key >>> 16);
        if (this.headerBytes.length < 12) {
            throw new ZipException("invalid header bytes generated, cannot perform standard encryption");
        }
        this.encryptData(this.headerBytes);
    }

    @Override
    public int encryptData(byte[] buff) throws ZipException {
        if (buff == null) {
            throw new NullPointerException();
        }
        return this.encryptData(buff, 0, buff.length);
    }

    @Override
    public int encryptData(byte[] buff, int start, int len) throws ZipException {
        if (len < 0) {
            throw new ZipException("invalid length specified to decrpyt data");
        }
        for (int i2 = start; i2 < start + len; ++i2) {
            buff[i2] = this.encryptByte(buff[i2]);
        }
        return len;
    }

    protected byte encryptByte(byte val) {
        byte temp_val = (byte)(val ^ this.zipCryptoEngine.decryptByte() & 0xFF);
        this.zipCryptoEngine.updateKeys(val);
        return temp_val;
    }

    protected byte[] generateRandomBytes(int size) throws ZipException {
        if (size <= 0) {
            throw new ZipException("size is either 0 or less than 0, cannot generate header for standard encryptor");
        }
        byte[] buff = new byte[size];
        SecureRandom random = new SecureRandom();
        for (int i2 = 0; i2 < buff.length; ++i2) {
            buff[i2] = this.encryptByte((byte)random.nextInt(256));
        }
        return buff;
    }

    public byte[] getHeaderBytes() {
        return this.headerBytes;
    }
}

