/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.transform.impl;

import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.Constants;
import net.sf.cglib.core.Local;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.TypeUtils;
import net.sf.cglib.transform.ClassEmitterTransformer;
import net.sf.cglib.transform.impl.InterceptFieldFilter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public class InterceptFieldTransformer
extends ClassEmitterTransformer {
    private static final String CALLBACK_FIELD = "$CGLIB_READ_WRITE_CALLBACK";
    private static final Type CALLBACK = TypeUtils.parseType("net.sf.cglib.transform.impl.InterceptFieldCallback");
    private static final Type ENABLED = TypeUtils.parseType("net.sf.cglib.transform.impl.InterceptFieldEnabled");
    private static final Signature ENABLED_SET = new Signature("setInterceptFieldCallback", Type.VOID_TYPE, new Type[]{CALLBACK});
    private static final Signature ENABLED_GET = new Signature("getInterceptFieldCallback", CALLBACK, new Type[0]);
    private InterceptFieldFilter filter;

    public InterceptFieldTransformer(InterceptFieldFilter filter) {
        this.filter = filter;
    }

    public void begin_class(int version, int access, String className, Type superType, Type[] interfaces, String sourceFile) {
        if (!TypeUtils.isInterface(access)) {
            super.begin_class(version, access, className, superType, TypeUtils.add(interfaces, ENABLED), sourceFile);
            super.declare_field(130, CALLBACK_FIELD, CALLBACK, null);
            CodeEmitter e2 = super.begin_method(1, ENABLED_GET, null);
            e2.load_this();
            e2.getfield(CALLBACK_FIELD);
            e2.return_value();
            e2.end_method();
            e2 = super.begin_method(1, ENABLED_SET, null);
            e2.load_this();
            e2.load_arg(0);
            e2.putfield(CALLBACK_FIELD);
            e2.return_value();
            e2.end_method();
        } else {
            super.begin_class(version, access, className, superType, interfaces, sourceFile);
        }
    }

    public void declare_field(int access, String name, Type type, Object value) {
        super.declare_field(access, name, type, value);
        if (!TypeUtils.isStatic(access)) {
            if (this.filter.acceptRead(this.getClassType(), name)) {
                this.addReadMethod(name, type);
            }
            if (this.filter.acceptWrite(this.getClassType(), name)) {
                this.addWriteMethod(name, type);
            }
        }
    }

    private void addReadMethod(String name, Type type) {
        CodeEmitter e2 = super.begin_method(1, InterceptFieldTransformer.readMethodSig(name, type.getDescriptor()), null);
        e2.load_this();
        e2.getfield(name);
        e2.load_this();
        e2.invoke_interface(ENABLED, ENABLED_GET);
        Label intercept = e2.make_label();
        e2.ifnonnull(intercept);
        e2.return_value();
        e2.mark(intercept);
        Local result = e2.make_local(type);
        e2.store_local(result);
        e2.load_this();
        e2.invoke_interface(ENABLED, ENABLED_GET);
        e2.load_this();
        e2.push(name);
        e2.load_local(result);
        e2.invoke_interface(CALLBACK, InterceptFieldTransformer.readCallbackSig(type));
        if (!TypeUtils.isPrimitive(type)) {
            e2.checkcast(type);
        }
        e2.return_value();
        e2.end_method();
    }

    private void addWriteMethod(String name, Type type) {
        CodeEmitter e2 = super.begin_method(1, InterceptFieldTransformer.writeMethodSig(name, type.getDescriptor()), null);
        e2.load_this();
        e2.dup();
        e2.invoke_interface(ENABLED, ENABLED_GET);
        Label skip = e2.make_label();
        e2.ifnull(skip);
        e2.load_this();
        e2.invoke_interface(ENABLED, ENABLED_GET);
        e2.load_this();
        e2.push(name);
        e2.load_this();
        e2.getfield(name);
        e2.load_arg(0);
        e2.invoke_interface(CALLBACK, InterceptFieldTransformer.writeCallbackSig(type));
        if (!TypeUtils.isPrimitive(type)) {
            e2.checkcast(type);
        }
        Label go = e2.make_label();
        e2.goTo(go);
        e2.mark(skip);
        e2.load_arg(0);
        e2.mark(go);
        e2.putfield(name);
        e2.return_value();
        e2.end_method();
    }

    public CodeEmitter begin_method(int access, Signature sig, Type[] exceptions) {
        return new CodeEmitter(super.begin_method(access, sig, exceptions)){

            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                Type towner = TypeUtils.fromInternalName(owner);
                switch (opcode) {
                    case 180: {
                        if (!InterceptFieldTransformer.this.filter.acceptRead(towner, name)) break;
                        this.helper(towner, InterceptFieldTransformer.readMethodSig(name, desc));
                        return;
                    }
                    case 181: {
                        if (!InterceptFieldTransformer.this.filter.acceptWrite(towner, name)) break;
                        this.helper(towner, InterceptFieldTransformer.writeMethodSig(name, desc));
                        return;
                    }
                }
                super.visitFieldInsn(opcode, owner, name, desc);
            }

            private void helper(Type owner, Signature sig) {
                this.invoke_virtual(owner, sig);
            }
        };
    }

    private static Signature readMethodSig(String name, String desc) {
        return new Signature("$cglib_read_" + name, "()" + desc);
    }

    private static Signature writeMethodSig(String name, String desc) {
        return new Signature("$cglib_write_" + name, "(" + desc + ")V");
    }

    private static Signature readCallbackSig(Type type) {
        Type remap = InterceptFieldTransformer.remap(type);
        return new Signature("read" + InterceptFieldTransformer.callbackName(remap), remap, new Type[]{Constants.TYPE_OBJECT, Constants.TYPE_STRING, remap});
    }

    private static Signature writeCallbackSig(Type type) {
        Type remap = InterceptFieldTransformer.remap(type);
        return new Signature("write" + InterceptFieldTransformer.callbackName(remap), remap, new Type[]{Constants.TYPE_OBJECT, Constants.TYPE_STRING, remap, remap});
    }

    private static Type remap(Type type) {
        switch (type.getSort()) {
            case 9: 
            case 10: {
                return Constants.TYPE_OBJECT;
            }
        }
        return type;
    }

    private static String callbackName(Type type) {
        return type == Constants.TYPE_OBJECT ? "Object" : TypeUtils.upperFirst(TypeUtils.getClassName(type));
    }
}

