/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.transport.bio;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.io.ChannelData;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.catalina.tribes.transport.AbstractSender;
import org.apache.catalina.tribes.transport.MultiPointSender;
import org.apache.catalina.tribes.transport.bio.BioSender;

public class MultipointBioSender
extends AbstractSender
implements MultiPointSender {
    protected final HashMap<Member, BioSender> bioSenders = new HashMap();

    @Override
    public synchronized void sendMessage(Member[] destination, ChannelMessage msg) throws ChannelException {
        byte[] data = XByteBuffer.createDataPackage((ChannelData)msg);
        BioSender[] senders = this.setupForSend(destination);
        ChannelException cx = null;
        for (int i2 = 0; i2 < senders.length; ++i2) {
            try {
                senders[i2].sendMessage(data, (msg.getOptions() & 2) == 2);
                continue;
            }
            catch (Exception x) {
                if (cx == null) {
                    cx = new ChannelException(x);
                }
                cx.addFaultyMember(destination[i2], x);
            }
        }
        if (cx != null) {
            throw cx;
        }
    }

    protected BioSender[] setupForSend(Member[] destination) throws ChannelException {
        ChannelException cx = null;
        BioSender[] result = new BioSender[destination.length];
        for (int i2 = 0; i2 < destination.length; ++i2) {
            try {
                BioSender sender = this.bioSenders.get(destination[i2]);
                if (sender == null) {
                    sender = new BioSender();
                    AbstractSender.transferProperties(this, sender);
                    sender.setDestination(destination[i2]);
                    this.bioSenders.put(destination[i2], sender);
                }
                result[i2] = sender;
                if (!result[i2].isConnected()) {
                    result[i2].connect();
                }
                result[i2].keepalive();
                continue;
            }
            catch (Exception x) {
                if (cx == null) {
                    cx = new ChannelException(x);
                }
                cx.addFaultyMember(destination[i2], x);
            }
        }
        if (cx != null) {
            throw cx;
        }
        return result;
    }

    @Override
    public void connect() throws IOException {
        this.setConnected(true);
    }

    private synchronized void close() throws ChannelException {
        ChannelException x = null;
        Object[] members = this.bioSenders.keySet().toArray();
        for (int i2 = 0; i2 < members.length; ++i2) {
            Member mbr = (Member)members[i2];
            try {
                BioSender sender = this.bioSenders.get(mbr);
                sender.disconnect();
            }
            catch (Exception e2) {
                if (x == null) {
                    x = new ChannelException(e2);
                }
                x.addFaultyMember(mbr, e2);
            }
            this.bioSenders.remove(mbr);
        }
        if (x != null) {
            throw x;
        }
    }

    @Override
    public void add(Member member) {
    }

    @Override
    public void remove(Member member) {
        BioSender sender = this.bioSenders.remove(member);
        if (sender != null) {
            sender.disconnect();
        }
    }

    @Override
    public synchronized void disconnect() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setConnected(false);
    }

    protected void finalize() throws Throwable {
        try {
            this.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.finalize();
    }

    @Override
    public boolean keepalive() {
        boolean result = false;
        Map.Entry[] entries = this.bioSenders.entrySet().toArray(new Map.Entry[0]);
        for (int i2 = 0; i2 < entries.length; ++i2) {
            BioSender sender = (BioSender)entries[i2].getValue();
            if (!sender.keepalive()) continue;
            this.bioSenders.remove(entries[i2].getKey());
        }
        return result;
    }
}

