/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.access;

import java.io.IOException;
import org.apache.commons.jcs.access.behavior.ICacheAccessManagement;
import org.apache.commons.jcs.access.exception.CacheException;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs.engine.behavior.IElementAttributes;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.stats.behavior.ICacheStats;

public abstract class AbstractCacheAccess<K, V>
implements ICacheAccessManagement {
    private final CompositeCache<K, V> cacheControl;

    protected AbstractCacheAccess(CompositeCache<K, V> cacheControl) {
        this.cacheControl = cacheControl;
    }

    @Override
    public void clear() throws CacheException {
        try {
            this.getCacheControl().removeAll();
        }
        catch (IOException e2) {
            throw new CacheException(e2);
        }
    }

    @Override
    public void setDefaultElementAttributes(IElementAttributes attr) throws CacheException {
        this.getCacheControl().setElementAttributes(attr);
    }

    @Override
    public IElementAttributes getDefaultElementAttributes() throws CacheException {
        return this.getCacheControl().getElementAttributes();
    }

    @Override
    public ICacheStats getStatistics() {
        return this.getCacheControl().getStatistics();
    }

    @Override
    public String getStats() {
        return this.getCacheControl().getStats();
    }

    @Override
    public void dispose() {
        this.getCacheControl().dispose();
    }

    @Override
    public ICompositeCacheAttributes getCacheAttributes() {
        return this.getCacheControl().getCacheAttributes();
    }

    @Override
    public void setCacheAttributes(ICompositeCacheAttributes cattr) {
        this.getCacheControl().setCacheAttributes(cattr);
    }

    @Override
    public int freeMemoryElements(int numberToFree) throws CacheException {
        int numFreed = -1;
        try {
            numFreed = this.getCacheControl().getMemoryCache().freeElements(numberToFree);
        }
        catch (IOException ioe) {
            String message = "Failure freeing memory elements.";
            throw new CacheException(message, ioe);
        }
        return numFreed;
    }

    public CompositeCache<K, V> getCacheControl() {
        return this.cacheControl;
    }
}

