/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.AbstractDiskCache;
import org.apache.commons.jcs.auxiliary.disk.jdbc.JDBCDiskCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.jdbc.TableState;
import org.apache.commons.jcs.auxiliary.disk.jdbc.dsfactory.DataSourceFactory;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEvent;
import org.apache.commons.jcs.engine.stats.StatElement;
import org.apache.commons.jcs.engine.stats.behavior.IStatElement;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.jcs.utils.serialization.StandardSerializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDBCDiskCache<K, V>
extends AbstractDiskCache<K, V> {
    private static final Log log = LogFactory.getLog(JDBCDiskCache.class);
    private IElementSerializer elementSerializer = new StandardSerializer();
    private JDBCDiskCacheAttributes jdbcDiskCacheAttributes;
    private AtomicInteger updateCount = new AtomicInteger(0);
    private AtomicInteger getCount = new AtomicInteger(0);
    private AtomicInteger getMatchingCount = new AtomicInteger(0);
    private static final int LOG_INTERVAL = 100;
    private DataSourceFactory dsFactory = null;
    private TableState tableState;

    public JDBCDiskCache(JDBCDiskCacheAttributes cattr, DataSourceFactory dsFactory, TableState tableState, ICompositeCacheManager compositeCacheManager) {
        super(cattr);
        this.setTableState(tableState);
        this.setJdbcDiskCacheAttributes(cattr);
        if (log.isInfoEnabled()) {
            log.info("jdbcDiskCacheAttributes = " + this.getJdbcDiskCacheAttributes());
        }
        this.dsFactory = dsFactory;
        this.setAlive(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processUpdate(ICacheElement<K, V> ce) {
        Connection con;
        this.updateCount.incrementAndGet();
        if (log.isDebugEnabled()) {
            log.debug("updating, ce = " + ce);
        }
        try {
            con = this.getDataSource().getConnection();
        }
        catch (SQLException e2) {
            log.error("Problem getting connection.", e2);
            return;
        }
        try {
            byte[] element;
            if (log.isDebugEnabled()) {
                log.debug("Putting [" + ce.getKey() + "] on disk.");
            }
            try {
                element = this.getElementSerializer().serialize(ce);
            }
            catch (IOException e3) {
                log.error("Could not serialize element", e3);
                try {
                    con.close();
                }
                catch (SQLException e4) {
                    log.error("Problem closing connection.", e4);
                }
                return;
            }
            this.insertOrUpdate(ce, con, element);
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException e5) {
                log.error("Problem closing connection.", e5);
            }
        }
        if (log.isInfoEnabled() && this.updateCount.get() % 100 == 0) {
            log.info("Update Count [" + this.updateCount + "]");
        }
    }

    private void insertOrUpdate(ICacheElement<K, V> ce, Connection con, byte[] element) {
        boolean exists = false;
        if (this.getJdbcDiskCacheAttributes().isTestBeforeInsert()) {
            exists = this.doesElementExist(ce, con);
        }
        if (!exists) {
            exists = this.insertRow(ce, con, element);
        }
        if (exists) {
            this.updateRow(ce, con, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insertRow(ICacheElement<K, V> ce, Connection con, byte[] element) {
        boolean exists = false;
        Statement psInsert = null;
        try {
            String sqlI = "insert into " + this.getJdbcDiskCacheAttributes().getTableName() + " (CACHE_KEY, REGION, ELEMENT, MAX_LIFE_SECONDS, IS_ETERNAL, CREATE_TIME, UPDATE_TIME_SECONDS, SYSTEM_EXPIRE_TIME_SECONDS)  values (?, ?, ?, ?, ?, ?, ?, ?)";
            psInsert = con.prepareStatement(sqlI);
            psInsert.setString(1, (String)ce.getKey());
            psInsert.setString(2, this.getCacheName());
            psInsert.setBytes(3, element);
            psInsert.setLong(4, ce.getElementAttributes().getMaxLife());
            if (ce.getElementAttributes().getIsEternal()) {
                psInsert.setString(5, "T");
            } else {
                psInsert.setString(5, "F");
            }
            Timestamp createTime = new Timestamp(ce.getElementAttributes().getCreateTime());
            psInsert.setTimestamp(6, createTime);
            long now = System.currentTimeMillis() / 1000L;
            psInsert.setLong(7, now);
            long expireTime = now + ce.getElementAttributes().getMaxLife();
            psInsert.setLong(8, expireTime);
            psInsert.execute();
        }
        catch (SQLException e2) {
            if ("23000".equals(e2.getSQLState())) {
                exists = true;
            } else {
                log.error("Could not insert element", e2);
            }
            if (!exists && !this.getJdbcDiskCacheAttributes().isTestBeforeInsert()) {
                exists = this.doesElementExist(ce, con);
            }
        }
        finally {
            if (psInsert != null) {
                try {
                    psInsert.close();
                }
                catch (SQLException e3) {
                    log.error("Problem closing statement.", e3);
                }
            }
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRow(ICacheElement<K, V> ce, Connection con, byte[] element) {
        String sqlU = null;
        Statement psUpdate = null;
        try {
            sqlU = "update " + this.getJdbcDiskCacheAttributes().getTableName() + " set ELEMENT  = ?, CREATE_TIME = ?, UPDATE_TIME_SECONDS = ?,  SYSTEM_EXPIRE_TIME_SECONDS = ?  where CACHE_KEY = ? and REGION = ?";
            psUpdate = con.prepareStatement(sqlU);
            psUpdate.setBytes(1, element);
            Timestamp createTime = new Timestamp(ce.getElementAttributes().getCreateTime());
            psUpdate.setTimestamp(2, createTime);
            long now = System.currentTimeMillis() / 1000L;
            psUpdate.setLong(3, now);
            long expireTime = now + ce.getElementAttributes().getMaxLife();
            psUpdate.setLong(4, expireTime);
            psUpdate.setString(5, (String)ce.getKey());
            psUpdate.setString(6, this.getCacheName());
            psUpdate.execute();
            if (log.isDebugEnabled()) {
                log.debug("ran update " + sqlU);
            }
        }
        catch (SQLException e2) {
            log.error("e2 sql [" + sqlU + "] Exception: ", e2);
        }
        finally {
            if (psUpdate != null) {
                try {
                    psUpdate.close();
                }
                catch (SQLException e2) {
                    log.error("Problem closing statement.", e2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doesElementExist(ICacheElement<K, V> ce, Connection con) {
        boolean exists = false;
        Statement psSelect = null;
        ResultSet rs = null;
        try {
            String sqlS = "select CACHE_KEY from " + this.getJdbcDiskCacheAttributes().getTableName() + " where REGION = ? and CACHE_KEY = ?";
            psSelect = con.prepareStatement(sqlS);
            psSelect.setString(1, this.getCacheName());
            psSelect.setString(2, (String)ce.getKey());
            rs = psSelect.executeQuery();
            if (rs.next()) {
                exists = true;
            }
            if (log.isDebugEnabled()) {
                log.debug("[" + ce.getKey() + "] existing status is " + exists);
            }
        }
        catch (SQLException e2) {
            log.error("Problem looking for item before insert.", e2);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e3) {
                log.error("Problem closing result set.", e3);
            }
            try {
                if (psSelect != null) {
                    psSelect.close();
                }
            }
            catch (SQLException e4) {
                log.error("Problem closing statement.", e4);
            }
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ICacheElement<K, V> processGet(K key) {
        this.getCount.incrementAndGet();
        if (log.isDebugEnabled()) {
            log.debug("Getting [" + key + "] from disk");
        }
        if (!this.isAlive()) {
            return null;
        }
        ICacheElement obj = null;
        byte[] data = null;
        try {
            String selectString = "select ELEMENT from " + this.getJdbcDiskCacheAttributes().getTableName() + " where REGION = ? and CACHE_KEY = ?";
            Connection con = this.getDataSource().getConnection();
            try {
                PreparedStatement psSelect = null;
                try {
                    psSelect = con.prepareStatement(selectString);
                    psSelect.setString(1, this.getCacheName());
                    psSelect.setString(2, key.toString());
                    ResultSet rs = psSelect.executeQuery();
                    try {
                        if (rs.next()) {
                            data = rs.getBytes(1);
                        }
                        if (data != null) {
                            try {
                                obj = (ICacheElement)this.getElementSerializer().deSerialize(data, null);
                            }
                            catch (IOException ioe) {
                                log.error("Problem getting item for key [" + key + "]", ioe);
                            }
                            catch (Exception e2) {
                                log.error("Problem getting item for key [" + key + "]", e2);
                            }
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (psSelect != null) {
                        psSelect.close();
                    }
                }
            }
            finally {
                if (con != null) {
                    con.close();
                }
            }
        }
        catch (SQLException sqle) {
            log.error("Caught a SQL exception trying to get the item for key [" + key + "]", sqle);
        }
        if (log.isInfoEnabled() && this.getCount.get() % 100 == 0) {
            log.info("Get Count [" + this.getCount + "]");
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<K, ICacheElement<K, V>> processGetMatching(String pattern) {
        HashMap<String, ICacheElement> results;
        block22: {
            this.getMatchingCount.incrementAndGet();
            if (log.isDebugEnabled()) {
                log.debug("Getting [" + pattern + "] from disk");
            }
            if (!this.isAlive()) {
                return null;
            }
            results = new HashMap<String, ICacheElement>();
            try {
                String selectString = "select CACHE_KEY, ELEMENT from " + this.getJdbcDiskCacheAttributes().getTableName() + " where REGION = ? and CACHE_KEY like ?";
                Connection con = this.getDataSource().getConnection();
                try {
                    PreparedStatement psSelect = null;
                    try {
                        psSelect = con.prepareStatement(selectString);
                        psSelect.setString(1, this.getCacheName());
                        psSelect.setString(2, this.constructLikeParameterFromPattern(pattern));
                        ResultSet rs = psSelect.executeQuery();
                        block14: while (true) {
                            while (rs.next()) {
                                String key = rs.getString(1);
                                byte[] data = rs.getBytes(2);
                                if (data == null) continue;
                                try {
                                    ICacheElement value = (ICacheElement)this.getElementSerializer().deSerialize(data, null);
                                    results.put(key, value);
                                    continue block14;
                                }
                                catch (IOException ioe) {
                                    log.error("Problem getting items for pattern [" + pattern + "]", ioe);
                                }
                                catch (Exception e2) {
                                    log.error("Problem getting items for pattern [" + pattern + "]", e2);
                                }
                            }
                            break block22;
                            {
                                continue block14;
                                break;
                            }
                            break;
                        }
                        finally {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                    }
                    finally {
                        if (psSelect != null) {
                            psSelect.close();
                        }
                    }
                }
                finally {
                    if (con != null) {
                        con.close();
                    }
                }
            }
            catch (SQLException sqle) {
                log.error("Caught a SQL exception trying to get items for pattern [" + pattern + "]", sqle);
            }
        }
        if (log.isInfoEnabled() && this.getMatchingCount.get() % 100 == 0) {
            log.info("Get Matching Count [" + this.getMatchingCount + "]");
        }
        return results;
    }

    public String constructLikeParameterFromPattern(String pattern) {
        String likePattern = pattern.replaceAll("\\.\\+", "%");
        likePattern = likePattern.replaceAll("\\.", "_");
        if (log.isDebugEnabled()) {
            log.debug("pattern = [" + likePattern + "]");
        }
        return likePattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean processRemove(K key) {
        String sql = "delete from " + this.getJdbcDiskCacheAttributes().getTableName() + " where REGION = ? and CACHE_KEY = ?";
        try {
            boolean partial = false;
            if (key instanceof String && key.toString().endsWith(":")) {
                sql = "delete from " + this.getJdbcDiskCacheAttributes().getTableName() + " where REGION = ? and CACHE_KEY like ?";
                partial = true;
            }
            Connection con = this.getDataSource().getConnection();
            PreparedStatement psSelect = null;
            try {
                psSelect = con.prepareStatement(sql);
                psSelect.setString(1, this.getCacheName());
                if (partial) {
                    psSelect.setString(2, key.toString() + "%");
                } else {
                    psSelect.setString(2, key.toString());
                }
                psSelect.executeUpdate();
                this.setAlive(true);
            }
            catch (SQLException e2) {
                log.error("Problem creating statement. sql [" + sql + "]", e2);
                this.setAlive(false);
            }
            finally {
                try {
                    if (psSelect != null) {
                        psSelect.close();
                    }
                    con.close();
                }
                catch (SQLException e1) {
                    log.error("Problem closing statement.", e1);
                }
            }
        }
        catch (SQLException e3) {
            log.error("Problem updating cache.", e3);
            this.reset();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processRemoveAll() {
        if (this.jdbcDiskCacheAttributes.isAllowRemoveAll()) {
            try {
                String sql = "delete from " + this.getJdbcDiskCacheAttributes().getTableName() + " where REGION = ?";
                Connection con = this.getDataSource().getConnection();
                PreparedStatement psDelete = null;
                try {
                    psDelete = con.prepareStatement(sql);
                    psDelete.setString(1, this.getCacheName());
                    this.setAlive(true);
                    psDelete.executeUpdate();
                }
                catch (SQLException e2) {
                    log.error("Problem creating statement.", e2);
                    this.setAlive(false);
                }
                finally {
                    try {
                        if (psDelete != null) {
                            psDelete.close();
                        }
                        con.close();
                    }
                    catch (SQLException e1) {
                        log.error("Problem closing statement.", e1);
                    }
                }
            }
            catch (Exception e3) {
                log.error("Problem removing all.", e3);
                this.reset();
            }
        } else if (log.isInfoEnabled()) {
            log.info("RemoveAll was requested but the request was not fulfilled: allowRemoveAll is set to false.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int deleteExpired() {
        int deleted = 0;
        try {
            this.getTableState().setState(1);
            long now = System.currentTimeMillis() / 1000L;
            String sql = "delete from " + this.getJdbcDiskCacheAttributes().getTableName() + " where IS_ETERNAL = ? and REGION = ? and ? > SYSTEM_EXPIRE_TIME_SECONDS";
            Connection con = this.getDataSource().getConnection();
            PreparedStatement psDelete = null;
            try {
                psDelete = con.prepareStatement(sql);
                psDelete.setString(1, "F");
                psDelete.setString(2, this.getCacheName());
                psDelete.setLong(3, now);
                this.setAlive(true);
                deleted = psDelete.executeUpdate();
            }
            catch (SQLException e2) {
                log.error("Problem creating statement.", e2);
                this.setAlive(false);
            }
            finally {
                try {
                    if (psDelete != null) {
                        psDelete.close();
                    }
                    con.close();
                }
                catch (SQLException e1) {
                    log.error("Problem closing statement.", e1);
                }
            }
            this.logApplicationEvent(this.getAuxiliaryCacheAttributes().getName(), "deleteExpired", "Deleted expired elements.  URL: " + this.getDiskLocation());
        }
        catch (Exception e3) {
            this.logError(this.getAuxiliaryCacheAttributes().getName(), "deleteExpired", e3.getMessage() + " URL: " + this.getDiskLocation());
            log.error("Problem removing expired elements from the table.", e3);
            this.reset();
        }
        finally {
            this.getTableState().setState(0);
        }
        return deleted;
    }

    public void reset() {
    }

    @Override
    public void processDispose() {
        ICacheEvent<String> cacheEvent = this.createICacheEvent(this.getCacheName(), "none", "dispose");
        try {
            try {
                this.dsFactory.close();
            }
            catch (SQLException e2) {
                log.error("Problem shutting down.", e2);
            }
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        Connection con;
        int size = 0;
        String selectString = "select count(*) from " + this.getJdbcDiskCacheAttributes().getTableName() + " where REGION = ?";
        try {
            con = this.getDataSource().getConnection();
        }
        catch (SQLException e2) {
            log.error("Problem getting connection.", e2);
            return size;
        }
        try {
            PreparedStatement psSelect = null;
            try {
                psSelect = con.prepareStatement(selectString);
                psSelect.setString(1, this.getCacheName());
                ResultSet rs = null;
                rs = psSelect.executeQuery();
                try {
                    if (rs.next()) {
                        size = rs.getInt(1);
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (psSelect != null) {
                    psSelect.close();
                }
            }
        }
        catch (SQLException e3) {
            log.error("Problem getting size.", e3);
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException e4) {
                log.error("Problem closing connection.", e4);
            }
        }
        return size;
    }

    @Override
    public Set<K> getKeySet() throws IOException {
        throw new UnsupportedOperationException("Groups not implemented.");
    }

    @Override
    public void setElementSerializer(IElementSerializer elementSerializer) {
        this.elementSerializer = elementSerializer;
    }

    @Override
    public IElementSerializer getElementSerializer() {
        return this.elementSerializer;
    }

    protected void setJdbcDiskCacheAttributes(JDBCDiskCacheAttributes jdbcDiskCacheAttributes) {
        this.jdbcDiskCacheAttributes = jdbcDiskCacheAttributes;
    }

    protected JDBCDiskCacheAttributes getJdbcDiskCacheAttributes() {
        return this.jdbcDiskCacheAttributes;
    }

    @Override
    public AuxiliaryCacheAttributes getAuxiliaryCacheAttributes() {
        return this.getJdbcDiskCacheAttributes();
    }

    @Override
    public IStats getStatistics() {
        IStats stats = super.getStatistics();
        stats.setTypeName("JDBC/Abstract Disk Cache");
        List<IStatElement<?>> elems = stats.getStatElements();
        elems.add(new StatElement<AtomicInteger>("Update Count", this.updateCount));
        elems.add(new StatElement<AtomicInteger>("Get Count", this.getCount));
        elems.add(new StatElement<AtomicInteger>("Get Matching Count", this.getMatchingCount));
        elems.add(new StatElement<String>("DB URL", this.getJdbcDiskCacheAttributes().getUrl()));
        stats.setStatElements(elems);
        return stats;
    }

    protected String getTableName() {
        String name = "UNDEFINED";
        if (this.getJdbcDiskCacheAttributes() != null) {
            name = this.getJdbcDiskCacheAttributes().getTableName();
        }
        return name;
    }

    public void setTableState(TableState tableState) {
        this.tableState = tableState;
    }

    public TableState getTableState() {
        return this.tableState;
    }

    @Override
    protected String getDiskLocation() {
        return this.jdbcDiskCacheAttributes.getUrl();
    }

    public DataSource getDataSource() throws SQLException {
        return this.dsFactory.getDataSource();
    }

    public String toString() {
        return this.getStats();
    }
}

