/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;

public class ObjectInputStreamClassLoaderAware
extends ObjectInputStream {
    private final ClassLoader classLoader;

    public ObjectInputStreamClassLoaderAware(InputStream in, ClassLoader classLoader) throws IOException {
        super(in);
        this.classLoader = classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
        return Class.forName(BlacklistClassResolver.DEFAULT.check(desc.getName()), false, this.classLoader);
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Class[] cinterfaces = new Class[interfaces.length];
        for (int i2 = 0; i2 < interfaces.length; ++i2) {
            cinterfaces[i2] = Class.forName(interfaces[i2], false, this.classLoader);
        }
        try {
            return Proxy.getProxyClass(this.classLoader, cinterfaces);
        }
        catch (IllegalArgumentException e2) {
            throw new ClassNotFoundException(null, e2);
        }
    }

    private static class BlacklistClassResolver {
        private static final BlacklistClassResolver DEFAULT = new BlacklistClassResolver(BlacklistClassResolver.toArray(System.getProperty("jcs.serialization.class.blacklist", "org.codehaus.groovy.runtime.,org.apache.commons.collections.functors.,org.apache.xalan")), BlacklistClassResolver.toArray(System.getProperty("jcs.serialization.class.whitelist")));
        private final String[] blacklist;
        private final String[] whitelist;

        protected BlacklistClassResolver(String[] blacklist, String[] whitelist) {
            this.whitelist = whitelist;
            this.blacklist = blacklist;
        }

        protected boolean isBlacklisted(String name) {
            return this.whitelist != null && !BlacklistClassResolver.contains(this.whitelist, name) || BlacklistClassResolver.contains(this.blacklist, name);
        }

        public final String check(String name) {
            if (this.isBlacklisted(name)) {
                throw new SecurityException(name + " is not whitelisted as deserialisable, prevented before loading.");
            }
            return name;
        }

        private static String[] toArray(String property) {
            return property == null ? null : property.split(" *, *");
        }

        private static boolean contains(String[] list, String name) {
            if (list != null) {
                for (String white : list) {
                    if (!name.startsWith(white)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

