/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import java.io.Serializable;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.AbstractFieldMatrix;
import org.apache.commons.math3.linear.FieldMatrix;
import org.apache.commons.math3.linear.FieldMatrixChangingVisitor;
import org.apache.commons.math3.linear.FieldMatrixPreservingVisitor;
import org.apache.commons.math3.linear.MatrixDimensionMismatchException;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Array2DRowFieldMatrix<T extends FieldElement<T>>
extends AbstractFieldMatrix<T>
implements Serializable {
    private static final long serialVersionUID = 7260756672015356458L;
    private T[][] data;

    public Array2DRowFieldMatrix(Field<T> field) {
        super(field);
    }

    public Array2DRowFieldMatrix(Field<T> field, int rowDimension, int columnDimension) throws NotStrictlyPositiveException {
        super(field, rowDimension, columnDimension);
        this.data = (FieldElement[][])MathArrays.buildArray(field, rowDimension, columnDimension);
    }

    public Array2DRowFieldMatrix(T[][] d2) throws DimensionMismatchException, NullArgumentException, NoDataException {
        this(Array2DRowFieldMatrix.extractField(d2), (FieldElement[][])d2);
    }

    public Array2DRowFieldMatrix(Field<T> field, T[][] d2) throws DimensionMismatchException, NullArgumentException, NoDataException {
        super(field);
        this.copyIn((FieldElement[][])d2);
    }

    public Array2DRowFieldMatrix(T[][] d2, boolean copyArray) throws DimensionMismatchException, NoDataException, NullArgumentException {
        this(Array2DRowFieldMatrix.extractField(d2), (FieldElement[][])d2, copyArray);
    }

    public Array2DRowFieldMatrix(Field<T> field, T[][] d2, boolean copyArray) throws DimensionMismatchException, NoDataException, NullArgumentException {
        super(field);
        if (copyArray) {
            this.copyIn((FieldElement[][])d2);
        } else {
            MathUtils.checkNotNull(d2);
            int nRows = d2.length;
            if (nRows == 0) {
                throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_ROW);
            }
            int nCols = d2[0].length;
            if (nCols == 0) {
                throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_COLUMN);
            }
            for (int r2 = 1; r2 < nRows; ++r2) {
                if (d2[r2].length == nCols) continue;
                throw new DimensionMismatchException(nCols, d2[r2].length);
            }
            this.data = d2;
        }
    }

    public Array2DRowFieldMatrix(T[] v) throws NoDataException {
        this(Array2DRowFieldMatrix.extractField(v), (FieldElement[])v);
    }

    public Array2DRowFieldMatrix(Field<T> field, T[] v) {
        super(field);
        int nRows = v.length;
        this.data = (FieldElement[][])MathArrays.buildArray(this.getField(), nRows, 1);
        for (int row = 0; row < nRows; ++row) {
            this.data[row][0] = v[row];
        }
    }

    @Override
    public FieldMatrix<T> createMatrix(int rowDimension, int columnDimension) throws NotStrictlyPositiveException {
        return new Array2DRowFieldMatrix(this.getField(), rowDimension, columnDimension);
    }

    @Override
    public FieldMatrix<T> copy() {
        return new Array2DRowFieldMatrix(this.getField(), this.copyOut(), false);
    }

    @Override
    public Array2DRowFieldMatrix<T> add(Array2DRowFieldMatrix<T> m2) throws MatrixDimensionMismatchException {
        this.checkAdditionCompatible(m2);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        FieldElement[][] outData = (FieldElement[][])MathArrays.buildArray(this.getField(), rowCount, columnCount);
        for (int row = 0; row < rowCount; ++row) {
            T[] dataRow = this.data[row];
            T[] mRow = m2.data[row];
            FieldElement[] outDataRow = outData[row];
            for (int col = 0; col < columnCount; ++col) {
                outDataRow[col] = (FieldElement)dataRow[col].add(mRow[col]);
            }
        }
        return new Array2DRowFieldMatrix(this.getField(), outData, false);
    }

    @Override
    public Array2DRowFieldMatrix<T> subtract(Array2DRowFieldMatrix<T> m2) throws MatrixDimensionMismatchException {
        this.checkSubtractionCompatible(m2);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        FieldElement[][] outData = (FieldElement[][])MathArrays.buildArray(this.getField(), rowCount, columnCount);
        for (int row = 0; row < rowCount; ++row) {
            T[] dataRow = this.data[row];
            T[] mRow = m2.data[row];
            FieldElement[] outDataRow = outData[row];
            for (int col = 0; col < columnCount; ++col) {
                outDataRow[col] = (FieldElement)dataRow[col].subtract(mRow[col]);
            }
        }
        return new Array2DRowFieldMatrix(this.getField(), outData, false);
    }

    @Override
    public Array2DRowFieldMatrix<T> multiply(Array2DRowFieldMatrix<T> m2) throws DimensionMismatchException {
        this.checkMultiplicationCompatible(m2);
        int nRows = this.getRowDimension();
        int nCols = m2.getColumnDimension();
        int nSum = this.getColumnDimension();
        FieldElement[][] outData = (FieldElement[][])MathArrays.buildArray(this.getField(), nRows, nCols);
        for (int row = 0; row < nRows; ++row) {
            T[] dataRow = this.data[row];
            FieldElement[] outDataRow = outData[row];
            for (int col = 0; col < nCols; ++col) {
                FieldElement sum = (FieldElement)this.getField().getZero();
                for (int i2 = 0; i2 < nSum; ++i2) {
                    sum = (FieldElement)sum.add(dataRow[i2].multiply(m2.data[i2][col]));
                }
                outDataRow[col] = sum;
            }
        }
        return new Array2DRowFieldMatrix(this.getField(), outData, false);
    }

    @Override
    public T[][] getData() {
        return this.copyOut();
    }

    public T[][] getDataRef() {
        return this.data;
    }

    @Override
    public void setSubMatrix(T[][] subMatrix, int row, int column) throws OutOfRangeException, NullArgumentException, NoDataException, DimensionMismatchException {
        if (this.data == null) {
            if (row > 0) {
                throw new MathIllegalStateException(LocalizedFormats.FIRST_ROWS_NOT_INITIALIZED_YET, row);
            }
            if (column > 0) {
                throw new MathIllegalStateException(LocalizedFormats.FIRST_COLUMNS_NOT_INITIALIZED_YET, column);
            }
            int nRows = subMatrix.length;
            if (nRows == 0) {
                throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_ROW);
            }
            int nCols = subMatrix[0].length;
            if (nCols == 0) {
                throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_COLUMN);
            }
            this.data = (FieldElement[][])MathArrays.buildArray(this.getField(), subMatrix.length, nCols);
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                if (subMatrix[i2].length != nCols) {
                    throw new DimensionMismatchException(nCols, subMatrix[i2].length);
                }
                System.arraycopy(subMatrix[i2], 0, this.data[i2 + row], column, nCols);
            }
        } else {
            super.setSubMatrix(subMatrix, row, column);
        }
    }

    @Override
    public T getEntry(int row, int column) throws OutOfRangeException {
        this.checkRowIndex(row);
        this.checkColumnIndex(column);
        return this.data[row][column];
    }

    @Override
    public void setEntry(int row, int column, T value) throws OutOfRangeException {
        this.checkRowIndex(row);
        this.checkColumnIndex(column);
        this.data[row][column] = value;
    }

    @Override
    public void addToEntry(int row, int column, T increment) throws OutOfRangeException {
        this.checkRowIndex(row);
        this.checkColumnIndex(column);
        this.data[row][column] = (FieldElement)this.data[row][column].add(increment);
    }

    @Override
    public void multiplyEntry(int row, int column, T factor) throws OutOfRangeException {
        this.checkRowIndex(row);
        this.checkColumnIndex(column);
        this.data[row][column] = (FieldElement)this.data[row][column].multiply(factor);
    }

    @Override
    public int getRowDimension() {
        return this.data == null ? 0 : this.data.length;
    }

    @Override
    public int getColumnDimension() {
        return this.data == null || this.data[0] == null ? 0 : this.data[0].length;
    }

    @Override
    public T[] operate(T[] v) throws DimensionMismatchException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v.length != nCols) {
            throw new DimensionMismatchException(v.length, nCols);
        }
        FieldElement[] out = (FieldElement[])MathArrays.buildArray(this.getField(), nRows);
        for (int row = 0; row < nRows; ++row) {
            T[] dataRow = this.data[row];
            FieldElement sum = (FieldElement)this.getField().getZero();
            for (int i2 = 0; i2 < nCols; ++i2) {
                sum = (FieldElement)sum.add(dataRow[i2].multiply(v[i2]));
            }
            out[row] = sum;
        }
        return out;
    }

    @Override
    public T[] preMultiply(T[] v) throws DimensionMismatchException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v.length != nRows) {
            throw new DimensionMismatchException(v.length, nRows);
        }
        FieldElement[] out = (FieldElement[])MathArrays.buildArray(this.getField(), nCols);
        for (int col = 0; col < nCols; ++col) {
            FieldElement sum = (FieldElement)this.getField().getZero();
            for (int i2 = 0; i2 < nRows; ++i2) {
                sum = (FieldElement)sum.add(this.data[i2][col].multiply(v[i2]));
            }
            out[col] = sum;
        }
        return out;
    }

    @Override
    public T walkInRowOrder(FieldMatrixChangingVisitor<T> visitor) {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int i2 = 0; i2 < rows; ++i2) {
            T[] rowI = this.data[i2];
            for (int j2 = 0; j2 < columns; ++j2) {
                rowI[j2] = visitor.visit(i2, j2, rowI[j2]);
            }
        }
        return visitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixPreservingVisitor<T> visitor) {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int i2 = 0; i2 < rows; ++i2) {
            T[] rowI = this.data[i2];
            for (int j2 = 0; j2 < columns; ++j2) {
                visitor.visit(i2, j2, rowI[j2]);
            }
        }
        return visitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixChangingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws OutOfRangeException, NumberIsTooSmallException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int i2 = startRow; i2 <= endRow; ++i2) {
            T[] rowI = this.data[i2];
            for (int j2 = startColumn; j2 <= endColumn; ++j2) {
                rowI[j2] = visitor.visit(i2, j2, rowI[j2]);
            }
        }
        return visitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixPreservingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws OutOfRangeException, NumberIsTooSmallException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int i2 = startRow; i2 <= endRow; ++i2) {
            T[] rowI = this.data[i2];
            for (int j2 = startColumn; j2 <= endColumn; ++j2) {
                visitor.visit(i2, j2, rowI[j2]);
            }
        }
        return visitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixChangingVisitor<T> visitor) {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int j2 = 0; j2 < columns; ++j2) {
            for (int i2 = 0; i2 < rows; ++i2) {
                T[] rowI = this.data[i2];
                rowI[j2] = visitor.visit(i2, j2, rowI[j2]);
            }
        }
        return visitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixPreservingVisitor<T> visitor) {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int j2 = 0; j2 < columns; ++j2) {
            for (int i2 = 0; i2 < rows; ++i2) {
                visitor.visit(i2, j2, this.data[i2][j2]);
            }
        }
        return visitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixChangingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws OutOfRangeException, NumberIsTooSmallException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int j2 = startColumn; j2 <= endColumn; ++j2) {
            for (int i2 = startRow; i2 <= endRow; ++i2) {
                T[] rowI = this.data[i2];
                rowI[j2] = visitor.visit(i2, j2, rowI[j2]);
            }
        }
        return visitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixPreservingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws OutOfRangeException, NumberIsTooSmallException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int j2 = startColumn; j2 <= endColumn; ++j2) {
            for (int i2 = startRow; i2 <= endRow; ++i2) {
                visitor.visit(i2, j2, this.data[i2][j2]);
            }
        }
        return visitor.end();
    }

    private T[][] copyOut() {
        int nRows = this.getRowDimension();
        FieldElement[][] out = (FieldElement[][])MathArrays.buildArray(this.getField(), nRows, this.getColumnDimension());
        for (int i2 = 0; i2 < nRows; ++i2) {
            System.arraycopy(this.data[i2], 0, out[i2], 0, this.data[i2].length);
        }
        return out;
    }

    private void copyIn(T[][] in) throws NullArgumentException, NoDataException, DimensionMismatchException {
        this.setSubMatrix((FieldElement[][])in, 0, 0);
    }
}

