/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.fmt;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.core.Config;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.core.Util;
import org.apache.taglibs.standard.tag.common.fmt.BundleSupport;

public abstract class SetLocaleSupport
extends TagSupport {
    private static final char HYPHEN = '-';
    private static final char UNDERSCORE = '_';
    protected Object value;
    protected String variant;
    private int scope;
    static Locale[] availableFormattingLocales;

    public SetLocaleSupport() {
        this.init();
    }

    private void init() {
        this.variant = null;
        this.value = null;
        this.scope = 1;
    }

    public void setScope(String scope) {
        this.scope = Util.getScope(scope);
    }

    public int doEndTag() throws JspException {
        Locale locale = null;
        locale = this.value == null ? Locale.getDefault() : (this.value instanceof String ? (((String)this.value).trim().equals("") ? Locale.getDefault() : SetLocaleSupport.parseLocale((String)this.value, this.variant)) : (Locale)this.value);
        Config.set(this.pageContext, "javax.servlet.jsp.jstl.fmt.locale", locale, this.scope);
        SetLocaleSupport.setResponseLocale(this.pageContext, locale);
        return 6;
    }

    public void release() {
        this.init();
    }

    public static Locale parseLocale(String locale) {
        return SetLocaleSupport.parseLocale(locale, null);
    }

    public static Locale parseLocale(String locale, String variant) {
        Locale ret = null;
        String language = locale;
        String country = null;
        int index = -1;
        index = locale.indexOf(45);
        if (index > -1 || (index = locale.indexOf(95)) > -1) {
            language = locale.substring(0, index);
            country = locale.substring(index + 1);
        }
        if (language == null || language.length() == 0) {
            throw new IllegalArgumentException(Resources.getMessage("LOCALE_NO_LANGUAGE"));
        }
        if (country == null) {
            ret = variant != null ? new Locale(language, "", variant) : new Locale(language, "");
        } else if (country.length() > 0) {
            ret = variant != null ? new Locale(language, country, variant) : new Locale(language, country);
        } else {
            throw new IllegalArgumentException(Resources.getMessage("LOCALE_EMPTY_COUNTRY"));
        }
        return ret;
    }

    static void setResponseLocale(PageContext pc, Locale locale) {
        ServletResponse response = pc.getResponse();
        response.setLocale(locale);
        if (pc.getSession() != null) {
            try {
                pc.setAttribute("javax.servlet.jsp.jstl.fmt.request.charset", response.getCharacterEncoding(), 3);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    static Locale getFormattingLocale(PageContext pc, Tag fromTag, boolean format, Locale[] avail) {
        LocalizationContext locCtxt = null;
        Tag parent = SetLocaleSupport.findAncestorWithClass(fromTag, BundleSupport.class);
        if (parent != null && (locCtxt = ((BundleSupport)parent).getLocalizationContext()).getLocale() != null) {
            if (format) {
                SetLocaleSupport.setResponseLocale(pc, locCtxt.getLocale());
            }
            return locCtxt.getLocale();
        }
        locCtxt = BundleSupport.getLocalizationContext(pc);
        if (locCtxt != null && locCtxt.getLocale() != null) {
            if (format) {
                SetLocaleSupport.setResponseLocale(pc, locCtxt.getLocale());
            }
            return locCtxt.getLocale();
        }
        Locale match = null;
        Locale pref = SetLocaleSupport.getLocale(pc, "javax.servlet.jsp.jstl.fmt.locale");
        match = pref != null ? SetLocaleSupport.findFormattingMatch(pref, avail) : SetLocaleSupport.findFormattingMatch(pc, avail);
        if (match == null && (pref = SetLocaleSupport.getLocale(pc, "javax.servlet.jsp.jstl.fmt.fallbackLocale")) != null) {
            match = SetLocaleSupport.findFormattingMatch(pref, avail);
        }
        if (format && match != null) {
            SetLocaleSupport.setResponseLocale(pc, match);
        }
        return match;
    }

    static Locale getFormattingLocale(PageContext pc) {
        Locale match = null;
        Locale pref = SetLocaleSupport.getLocale(pc, "javax.servlet.jsp.jstl.fmt.locale");
        match = pref != null ? SetLocaleSupport.findFormattingMatch(pref, availableFormattingLocales) : SetLocaleSupport.findFormattingMatch(pc, availableFormattingLocales);
        if (match == null && (pref = SetLocaleSupport.getLocale(pc, "javax.servlet.jsp.jstl.fmt.fallbackLocale")) != null) {
            match = SetLocaleSupport.findFormattingMatch(pref, availableFormattingLocales);
        }
        if (match != null) {
            SetLocaleSupport.setResponseLocale(pc, match);
        }
        return match;
    }

    static Locale getLocale(PageContext pageContext, String name) {
        Locale loc = null;
        Object obj = Config.find(pageContext, name);
        if (obj != null) {
            loc = obj instanceof Locale ? (Locale)obj : SetLocaleSupport.parseLocale((String)obj);
        }
        return loc;
    }

    private static Locale findFormattingMatch(PageContext pageContext, Locale[] avail) {
        Locale locale;
        Locale match = null;
        Enumeration enum_ = Util.getRequestLocales((HttpServletRequest)pageContext.getRequest());
        while (enum_.hasMoreElements() && (match = SetLocaleSupport.findFormattingMatch(locale = (Locale)enum_.nextElement(), avail)) == null) {
        }
        return match;
    }

    private static Locale findFormattingMatch(Locale pref, Locale[] avail) {
        Locale match = null;
        boolean langAndCountryMatch = false;
        for (int i2 = 0; i2 < avail.length; ++i2) {
            if (pref.equals(avail[i2])) {
                match = avail[i2];
                break;
            }
            if (!"".equals(pref.getVariant()) && "".equals(avail[i2].getVariant()) && pref.getLanguage().equals(avail[i2].getLanguage()) && pref.getCountry().equals(avail[i2].getCountry())) {
                match = avail[i2];
                langAndCountryMatch = true;
                continue;
            }
            if (langAndCountryMatch || !pref.getLanguage().equals(avail[i2].getLanguage()) || !"".equals(avail[i2].getCountry()) || match != null) continue;
            match = avail[i2];
        }
        return match;
    }

    static {
        Locale[] dateLocales = DateFormat.getAvailableLocales();
        Locale[] numberLocales = NumberFormat.getAvailableLocales();
        Vector<Locale> vec = new Vector<Locale>(dateLocales.length);
        block0: for (int i2 = 0; i2 < dateLocales.length; ++i2) {
            for (int j2 = 0; j2 < numberLocales.length; ++j2) {
                if (!dateLocales[i2].equals(numberLocales[j2])) continue;
                vec.add(dateLocales[i2]);
                continue block0;
            }
        }
        availableFormattingLocales = new Locale[vec.size()];
        availableFormattingLocales = vec.toArray(availableFormattingLocales);
    }
}

