/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tomcat.util.bcel.classfile.ConstantPool;
import org.apache.tomcat.util.bcel.classfile.ConstantUtf8;
import org.apache.tomcat.util.bcel.classfile.ElementValuePair;

public class AnnotationEntry {
    private final int type_index;
    private final ConstantPool constant_pool;
    private final List<ElementValuePair> element_value_pairs;

    AnnotationEntry(DataInput input, ConstantPool constant_pool) throws IOException {
        this.constant_pool = constant_pool;
        this.type_index = input.readUnsignedShort();
        int num_element_value_pairs = input.readUnsignedShort();
        this.element_value_pairs = new ArrayList<ElementValuePair>(num_element_value_pairs);
        for (int i2 = 0; i2 < num_element_value_pairs; ++i2) {
            this.element_value_pairs.add(new ElementValuePair(input, constant_pool));
        }
    }

    public String getAnnotationType() {
        ConstantUtf8 c2 = (ConstantUtf8)this.constant_pool.getConstant(this.type_index, (byte)1);
        return c2.getBytes();
    }

    public List<ElementValuePair> getElementValuePairs() {
        return this.element_value_pairs;
    }
}

