/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.jam.annotation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlbeans.impl.jam.JAnnotationValue;
import org.apache.xmlbeans.impl.jam.JClass;
import org.apache.xmlbeans.impl.jam.annotation.AnnotationProxy;
import org.apache.xmlbeans.impl.jam.internal.elements.AnnotationValueImpl;
import org.apache.xmlbeans.impl.jam.internal.elements.ElementContext;

public abstract class TypedAnnotationProxyBase
extends AnnotationProxy {
    private List mValues = null;

    protected TypedAnnotationProxyBase() {
    }

    @Override
    public void setValue(String name, Object value, JClass type) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        if (this.mValues == null) {
            this.mValues = new ArrayList();
        }
        this.mValues.add(new AnnotationValueImpl((ElementContext)((Object)this.mContext), name, value, type));
        Method m2 = this.getSetterFor(name, value.getClass());
        if (m2 == null) {
            return;
        }
        try {
            m2.invoke((Object)this, value);
        }
        catch (IllegalAccessException e2) {
            this.getLogger().warning(e2);
        }
        catch (InvocationTargetException e3) {
            this.getLogger().warning(e3);
        }
    }

    @Override
    public JAnnotationValue[] getValues() {
        if (this.mValues == null) {
            return new JAnnotationValue[0];
        }
        JAnnotationValue[] out = new JAnnotationValue[this.mValues.size()];
        this.mValues.toArray(out);
        return out;
    }

    protected Method getSetterFor(String memberName, Class valueType) {
        try {
            return this.getClass().getMethod("set" + memberName, valueType);
        }
        catch (NoSuchMethodException nsme) {
            this.getLogger().warning(nsme);
            return null;
        }
    }
}

