/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.jam.internal.elements;

import org.apache.xmlbeans.impl.jam.JAnnotation;
import org.apache.xmlbeans.impl.jam.JAnnotationValue;
import org.apache.xmlbeans.impl.jam.JClass;
import org.apache.xmlbeans.impl.jam.internal.classrefs.JClassRef;
import org.apache.xmlbeans.impl.jam.internal.classrefs.QualifiedJClassRef;
import org.apache.xmlbeans.impl.jam.internal.elements.ElementContext;

public class AnnotationValueImpl
implements JAnnotationValue {
    private Object mValue = null;
    private JClassRef mType = null;
    private String mName;
    private ElementContext mContext;

    public AnnotationValueImpl(ElementContext ctx, String name, Object value, JClass type) {
        if (ctx == null) {
            throw new IllegalArgumentException("null ctx");
        }
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        if (type == null) {
            throw new IllegalArgumentException("null type");
        }
        this.mValue = value.getClass().isArray() ? AnnotationValueImpl.ensureArrayWrapped(value) : value;
        this.mContext = ctx;
        this.mName = name;
        this.mType = QualifiedJClassRef.create(type);
    }

    @Override
    public boolean isDefaultValueUsed() {
        throw new IllegalStateException("NYI");
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public JClass getType() {
        return this.mType.getRefClass();
    }

    @Override
    public JAnnotation asAnnotation() {
        if (this.mValue instanceof JAnnotation) {
            return (JAnnotation)this.mValue;
        }
        return null;
    }

    @Override
    public JClass asClass() {
        if (this.mValue instanceof JClass) {
            return (JClass)this.mValue;
        }
        return null;
    }

    @Override
    public String asString() {
        if (this.mValue == null) {
            return null;
        }
        return this.mValue.toString();
    }

    @Override
    public int asInt() throws NumberFormatException {
        if (this.mValue == null) {
            return 0;
        }
        if (this.mValue instanceof Number) {
            return ((Number)this.mValue).intValue();
        }
        try {
            return Integer.parseInt(this.mValue.toString().trim());
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    @Override
    public boolean asBoolean() throws IllegalArgumentException {
        if (this.mValue == null) {
            return false;
        }
        return Boolean.valueOf(this.mValue.toString().trim());
    }

    @Override
    public long asLong() throws NumberFormatException {
        if (this.mValue == null) {
            return 0L;
        }
        if (this.mValue instanceof Number) {
            return ((Number)this.mValue).longValue();
        }
        try {
            return Long.parseLong(this.mValue.toString().trim());
        }
        catch (NumberFormatException nfe) {
            return 0L;
        }
    }

    @Override
    public short asShort() throws NumberFormatException {
        if (this.mValue == null) {
            return 0;
        }
        if (this.mValue instanceof Number) {
            return ((Number)this.mValue).shortValue();
        }
        try {
            return Short.parseShort(this.mValue.toString().trim());
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    @Override
    public double asDouble() throws NumberFormatException {
        if (this.mValue == null) {
            return 0.0;
        }
        if (this.mValue instanceof Number) {
            return ((Number)this.mValue).doubleValue();
        }
        try {
            return Double.parseDouble(this.mValue.toString().trim());
        }
        catch (NumberFormatException nfe) {
            return 0.0;
        }
    }

    @Override
    public float asFloat() throws NumberFormatException {
        if (this.mValue == null) {
            return 0.0f;
        }
        if (this.mValue instanceof Number) {
            return ((Number)this.mValue).floatValue();
        }
        try {
            return Float.parseFloat(this.mValue.toString().trim());
        }
        catch (NumberFormatException nfe) {
            return 0.0f;
        }
    }

    @Override
    public byte asByte() throws NumberFormatException {
        if (this.mValue == null) {
            return 0;
        }
        if (this.mValue instanceof Number) {
            return ((Number)this.mValue).byteValue();
        }
        try {
            return Byte.parseByte(this.mValue.toString().trim());
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    @Override
    public char asChar() throws IllegalArgumentException {
        if (this.mValue == null) {
            return '\u0000';
        }
        if (this.mValue instanceof Character) {
            return ((Character)this.mValue).charValue();
        }
        this.mValue = this.mValue.toString();
        return ((String)this.mValue).length() == 0 ? (char)'\u0000' : ((String)this.mValue).charAt(0);
    }

    @Override
    public JClass[] asClassArray() {
        if (this.mValue instanceof JClass[]) {
            return (JClass[])this.mValue;
        }
        return null;
    }

    @Override
    public JAnnotation[] asAnnotationArray() {
        if (this.mValue instanceof JAnnotation[]) {
            return (JAnnotation[])this.mValue;
        }
        return null;
    }

    @Override
    public String[] asStringArray() {
        if (!this.mValue.getClass().isArray()) {
            return null;
        }
        String[] out = new String[((Object[])this.mValue).length];
        for (int i2 = 0; i2 < out.length; ++i2) {
            if (((Object[])this.mValue)[i2] == null) {
                this.mContext.getLogger().error("Null annotation value array element on " + this.getName());
                out[i2] = "";
                continue;
            }
            out[i2] = ((Object[])this.mValue)[i2].toString();
        }
        return out;
    }

    @Override
    public int[] asIntArray() throws NumberFormatException {
        if (!this.mValue.getClass().isArray()) {
            return null;
        }
        int[] out = new int[((Object[])this.mValue).length];
        for (int i2 = 0; i2 < out.length; ++i2) {
            if (((Object[])this.mValue)[i2] == null) {
                this.mContext.getLogger().error("Null annotation value array element " + i2 + " on " + this.getName());
                out[i2] = 0;
                continue;
            }
            out[i2] = Integer.parseInt(((Object[])this.mValue)[i2].toString());
        }
        return out;
    }

    @Override
    public boolean[] asBooleanArray() throws IllegalArgumentException {
        if (!this.mValue.getClass().isArray()) {
            return null;
        }
        boolean[] out = new boolean[((Object[])this.mValue).length];
        for (int i2 = 0; i2 < out.length; ++i2) {
            if (((Object[])this.mValue)[i2] == null) {
                this.mContext.getLogger().error("Null annotation value array element " + i2 + " on " + this.getName());
                out[i2] = false;
                continue;
            }
            out[i2] = Boolean.valueOf(((Object[])this.mValue)[i2].toString());
        }
        return out;
    }

    @Override
    public short[] asShortArray() throws NumberFormatException {
        if (!this.mValue.getClass().isArray()) {
            return null;
        }
        short[] out = new short[((Object[])this.mValue).length];
        for (int i2 = 0; i2 < out.length; ++i2) {
            if (((Object[])this.mValue)[i2] == null) {
                this.mContext.getLogger().error("Null annotation value array element " + i2 + " on " + this.getName());
                out[i2] = 0;
                continue;
            }
            out[i2] = Short.parseShort(((Object[])this.mValue)[i2].toString());
        }
        return out;
    }

    @Override
    public long[] asLongArray() throws NumberFormatException {
        if (!this.mValue.getClass().isArray()) {
            return null;
        }
        long[] out = new long[((Object[])this.mValue).length];
        for (int i2 = 0; i2 < out.length; ++i2) {
            if (((Object[])this.mValue)[i2] == null) {
                this.mContext.getLogger().error("Null annotation value array element " + i2 + " on " + this.getName());
                out[i2] = 0L;
                continue;
            }
            out[i2] = Long.parseLong(((Object[])this.mValue)[i2].toString());
        }
        return out;
    }

    @Override
    public double[] asDoubleArray() throws NumberFormatException {
        if (!this.mValue.getClass().isArray()) {
            return null;
        }
        double[] out = new double[((Object[])this.mValue).length];
        for (int i2 = 0; i2 < out.length; ++i2) {
            if (((Object[])this.mValue)[i2] == null) {
                this.mContext.getLogger().error("Null annotation value array element " + i2 + " on " + this.getName());
                out[i2] = 0.0;
                continue;
            }
            out[i2] = Double.parseDouble(((Object[])this.mValue)[i2].toString());
        }
        return out;
    }

    @Override
    public float[] asFloatArray() throws NumberFormatException {
        if (!this.mValue.getClass().isArray()) {
            return null;
        }
        float[] out = new float[((Object[])this.mValue).length];
        for (int i2 = 0; i2 < out.length; ++i2) {
            if (((Object[])this.mValue)[i2] == null) {
                this.mContext.getLogger().error("Null annotation value array element " + i2 + " on " + this.getName());
                out[i2] = 0.0f;
                continue;
            }
            out[i2] = Float.parseFloat(((Object[])this.mValue)[i2].toString());
        }
        return out;
    }

    @Override
    public byte[] asByteArray() throws NumberFormatException {
        if (!this.mValue.getClass().isArray()) {
            return null;
        }
        byte[] out = new byte[((Object[])this.mValue).length];
        for (int i2 = 0; i2 < out.length; ++i2) {
            if (((Object[])this.mValue)[i2] == null) {
                this.mContext.getLogger().error("Null annotation value array element " + i2 + " on " + this.getName());
                out[i2] = 0;
                continue;
            }
            out[i2] = Byte.parseByte(((Object[])this.mValue)[i2].toString());
        }
        return out;
    }

    @Override
    public char[] asCharArray() throws IllegalArgumentException {
        if (!this.mValue.getClass().isArray()) {
            return null;
        }
        char[] out = new char[((Object[])this.mValue).length];
        for (int i2 = 0; i2 < out.length; ++i2) {
            if (((Object[])this.mValue)[i2] == null) {
                this.mContext.getLogger().error("Null annotation value array element " + i2 + " on " + this.getName());
                out[i2] = '\u0000';
                continue;
            }
            out[i2] = ((Object[])this.mValue)[i2].toString().charAt(0);
        }
        return out;
    }

    private static final Object[] ensureArrayWrapped(Object o2) {
        if (o2 instanceof Object[]) {
            return (Object[])o2;
        }
        if (o2 instanceof int[]) {
            int dims = ((int[])o2).length;
            Object[] out = new Integer[dims];
            for (int i2 = 0; i2 < dims; ++i2) {
                out[i2] = new Integer(((int[])o2)[i2]);
            }
            return out;
        }
        if (o2 instanceof boolean[]) {
            int dims = ((boolean[])o2).length;
            Object[] out = new Boolean[dims];
            for (int i3 = 0; i3 < dims; ++i3) {
                out[i3] = ((boolean[])o2)[i3];
            }
            return out;
        }
        if (o2 instanceof byte[]) {
            int dims = ((byte[])o2).length;
            Object[] out = new Byte[dims];
            for (int i4 = 0; i4 < dims; ++i4) {
                out[i4] = new Byte(((byte[])o2)[i4]);
            }
            return out;
        }
        if (o2 instanceof char[]) {
            int dims = ((char[])o2).length;
            Object[] out = new Character[dims];
            for (int i5 = 0; i5 < dims; ++i5) {
                out[i5] = new Character(((char[])o2)[i5]);
            }
            return out;
        }
        if (o2 instanceof float[]) {
            int dims = ((float[])o2).length;
            Object[] out = new Float[dims];
            for (int i6 = 0; i6 < dims; ++i6) {
                out[i6] = new Float(((float[])o2)[i6]);
            }
            return out;
        }
        if (o2 instanceof double[]) {
            int dims = ((double[])o2).length;
            Object[] out = new Double[dims];
            for (int i7 = 0; i7 < dims; ++i7) {
                out[i7] = new Double(((double[])o2)[i7]);
            }
            return out;
        }
        if (o2 instanceof long[]) {
            int dims = ((long[])o2).length;
            Object[] out = new Long[dims];
            for (int i8 = 0; i8 < dims; ++i8) {
                out[i8] = new Long(((long[])o2)[i8]);
            }
            return out;
        }
        if (o2 instanceof short[]) {
            int dims = ((short[])o2).length;
            Object[] out = new Short[dims];
            for (int i9 = 0; i9 < dims; ++i9) {
                out[i9] = new Short(((short[])o2)[i9]);
            }
            return out;
        }
        throw new IllegalStateException("Unknown array type " + o2.getClass());
    }

    @Override
    public Object getValue() {
        return this.mValue;
    }
}

