/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.jam.visitor;

import org.apache.xmlbeans.impl.jam.JAnnotatedElement;
import org.apache.xmlbeans.impl.jam.JAnnotation;
import org.apache.xmlbeans.impl.jam.JClass;
import org.apache.xmlbeans.impl.jam.JComment;
import org.apache.xmlbeans.impl.jam.JConstructor;
import org.apache.xmlbeans.impl.jam.JField;
import org.apache.xmlbeans.impl.jam.JInvokable;
import org.apache.xmlbeans.impl.jam.JMethod;
import org.apache.xmlbeans.impl.jam.JPackage;
import org.apache.xmlbeans.impl.jam.JParameter;
import org.apache.xmlbeans.impl.jam.visitor.JVisitor;

public class TraversingJVisitor
extends JVisitor {
    private JVisitor mDelegate;

    public TraversingJVisitor(JVisitor jv) {
        if (jv == null) {
            throw new IllegalArgumentException("null jv");
        }
        this.mDelegate = jv;
    }

    @Override
    public void visit(JPackage pkg) {
        pkg.accept(this.mDelegate);
        JClass[] c2 = pkg.getClasses();
        for (int i2 = 0; i2 < c2.length; ++i2) {
            this.visit(c2[i2]);
        }
        this.visitAnnotations(pkg);
        this.visitComment(pkg);
    }

    @Override
    public void visit(JClass clazz) {
        int i2;
        clazz.accept(this.mDelegate);
        JField[] f2 = clazz.getDeclaredFields();
        for (i2 = 0; i2 < f2.length; ++i2) {
            this.visit(f2[i2]);
        }
        JConstructor[] c2 = clazz.getConstructors();
        for (i2 = 0; i2 < c2.length; ++i2) {
            this.visit(c2[i2]);
        }
        JMethod[] m2 = clazz.getMethods();
        for (i2 = 0; i2 < m2.length; ++i2) {
            this.visit(m2[i2]);
        }
        this.visitAnnotations(clazz);
        this.visitComment(clazz);
    }

    @Override
    public void visit(JField field) {
        field.accept(this.mDelegate);
        this.visitAnnotations(field);
        this.visitComment(field);
    }

    @Override
    public void visit(JConstructor ctor) {
        ctor.accept(this.mDelegate);
        this.visitParameters(ctor);
        this.visitAnnotations(ctor);
        this.visitComment(ctor);
    }

    @Override
    public void visit(JMethod method) {
        method.accept(this.mDelegate);
        this.visitParameters(method);
        this.visitAnnotations(method);
        this.visitComment(method);
    }

    @Override
    public void visit(JParameter param) {
        param.accept(this.mDelegate);
        this.visitAnnotations(param);
        this.visitComment(param);
    }

    @Override
    public void visit(JAnnotation ann) {
        ann.accept(this.mDelegate);
    }

    @Override
    public void visit(JComment comment) {
        comment.accept(this.mDelegate);
    }

    private void visitParameters(JInvokable iv) {
        JParameter[] p2 = iv.getParameters();
        for (int i2 = 0; i2 < p2.length; ++i2) {
            this.visit(p2[i2]);
        }
    }

    private void visitAnnotations(JAnnotatedElement ae) {
        JAnnotation[] anns = ae.getAnnotations();
        for (int i2 = 0; i2 < anns.length; ++i2) {
            this.visit(anns[i2]);
        }
    }

    private void visitComment(JAnnotatedElement e2) {
        JComment c2 = e2.getComment();
        if (c2 != null) {
            this.visit(c2);
        }
    }
}

