/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile.annotation;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;
import org.aspectj.apache.bcel.classfile.Utility;
import org.aspectj.apache.bcel.classfile.annotation.ElementValue;
import org.aspectj.apache.bcel.classfile.annotation.NameValuePair;
import org.aspectj.apache.bcel.generic.ObjectType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationGen {
    public static final AnnotationGen[] NO_ANNOTATIONS = new AnnotationGen[0];
    private int typeIndex;
    private List<NameValuePair> pairs = Collections.emptyList();
    private ConstantPool cpool;
    private boolean isRuntimeVisible = false;

    public AnnotationGen(AnnotationGen a2, ConstantPool cpool, boolean copyPoolEntries) {
        this.cpool = cpool;
        this.typeIndex = copyPoolEntries ? cpool.addUtf8(a2.getTypeSignature()) : a2.getTypeIndex();
        this.isRuntimeVisible = a2.isRuntimeVisible();
        this.pairs = this.copyValues(a2.getValues(), cpool, copyPoolEntries);
    }

    private List<NameValuePair> copyValues(List<NameValuePair> in, ConstantPool cpool, boolean copyPoolEntries) {
        ArrayList<NameValuePair> out = new ArrayList<NameValuePair>();
        for (NameValuePair nvp : in) {
            out.add(new NameValuePair(nvp, cpool, copyPoolEntries));
        }
        return out;
    }

    private AnnotationGen(ConstantPool cpool) {
        this.cpool = cpool;
    }

    public AnnotationGen(ObjectType type, List<NameValuePair> pairs, boolean runtimeVisible, ConstantPool cpool) {
        this.cpool = cpool;
        if (type != null) {
            this.typeIndex = cpool.addUtf8(type.getSignature());
        }
        this.pairs = pairs;
        this.isRuntimeVisible = runtimeVisible;
    }

    public static AnnotationGen read(DataInputStream dis, ConstantPool cpool, boolean b2) throws IOException {
        AnnotationGen a2 = new AnnotationGen(cpool);
        a2.typeIndex = dis.readUnsignedShort();
        int elemValuePairCount = dis.readUnsignedShort();
        int i2 = 0;
        while (i2 < elemValuePairCount) {
            int nidx = dis.readUnsignedShort();
            a2.addElementNameValuePair(new NameValuePair(nidx, ElementValue.readElementValue(dis, cpool), cpool));
            ++i2;
        }
        a2.isRuntimeVisible(b2);
        return a2;
    }

    public void dump(DataOutputStream dos) throws IOException {
        dos.writeShort(this.typeIndex);
        dos.writeShort(this.pairs.size());
        int i2 = 0;
        while (i2 < this.pairs.size()) {
            NameValuePair envp = this.pairs.get(i2);
            envp.dump(dos);
            ++i2;
        }
    }

    public void addElementNameValuePair(NameValuePair evp) {
        if (this.pairs == Collections.EMPTY_LIST) {
            this.pairs = new ArrayList<NameValuePair>();
        }
        this.pairs.add(evp);
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public String getTypeSignature() {
        ConstantUtf8 utf8 = (ConstantUtf8)this.cpool.getConstant(this.typeIndex);
        return utf8.getValue();
    }

    public String getTypeName() {
        return Utility.signatureToString(this.getTypeSignature());
    }

    public List<NameValuePair> getValues() {
        return this.pairs;
    }

    public String toString() {
        StringBuffer s2 = new StringBuffer();
        s2.append("AnnotationGen:[" + this.getTypeName() + " #" + this.pairs.size() + " {");
        int i2 = 0;
        while (i2 < this.pairs.size()) {
            s2.append(this.pairs.get(i2));
            if (i2 + 1 < this.pairs.size()) {
                s2.append(",");
            }
            ++i2;
        }
        s2.append("}]");
        return s2.toString();
    }

    public String toShortString() {
        StringBuffer s2 = new StringBuffer();
        s2.append("@" + this.getTypeName() + "(");
        int i2 = 0;
        while (i2 < this.pairs.size()) {
            s2.append(this.pairs.get(i2));
            if (i2 + 1 < this.pairs.size()) {
                s2.append(",");
            }
            ++i2;
        }
        s2.append(")");
        return s2.toString();
    }

    private void isRuntimeVisible(boolean b2) {
        this.isRuntimeVisible = b2;
    }

    public boolean isRuntimeVisible() {
        return this.isRuntimeVisible;
    }

    public boolean hasNameValuePair(String name, String value) {
        for (NameValuePair pair : this.pairs) {
            if (!pair.getNameString().equals(name) || !pair.getValue().stringifyValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNamedValue(String name) {
        for (NameValuePair pair : this.pairs) {
            if (!pair.getNameString().equals(name)) continue;
            return true;
        }
        return false;
    }
}

