/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.aspectj.bridge.IMessage;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.Declare;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.PatternNodeVisitor;
import org.aspectj.weaver.patterns.TypePattern;
import org.aspectj.weaver.patterns.TypePatternList;

public class DeclarePrecedence
extends Declare {
    private TypePatternList patterns;
    private IScope scope = null;

    public DeclarePrecedence(List patterns) {
        this(new TypePatternList(patterns));
    }

    private DeclarePrecedence(TypePatternList patterns) {
        this.patterns = patterns;
    }

    public Object accept(PatternNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Declare parameterizeWith(Map typeVariableBindingMap, World w) {
        DeclarePrecedence ret = new DeclarePrecedence(this.patterns.parameterizeWith(typeVariableBindingMap, w));
        ret.copyLocationFrom(this);
        return ret;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("declare precedence: ");
        buf.append(this.patterns);
        buf.append(";");
        return buf.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof DeclarePrecedence)) {
            return false;
        }
        DeclarePrecedence o2 = (DeclarePrecedence)other;
        return o2.patterns.equals(this.patterns);
    }

    public int hashCode() {
        return this.patterns.hashCode();
    }

    public void write(DataOutputStream s2) throws IOException {
        s2.writeByte(4);
        this.patterns.write(s2);
        this.writeLocation(s2);
    }

    public static Declare read(VersionedDataInputStream s2, ISourceContext context) throws IOException {
        DeclarePrecedence ret = new DeclarePrecedence(TypePatternList.read(s2, context));
        ret.readLocation(context, s2);
        return ret;
    }

    public void setScopeForResolution(IScope scope) {
        this.scope = scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureResolved() {
        if (this.scope != null) {
            try {
                this.resolve(this.scope);
            }
            finally {
                this.scope = null;
            }
        }
    }

    public void resolve(IScope scope) {
        this.patterns = this.patterns.resolveBindings(scope, Bindings.NONE, false, false);
        boolean seenStar = false;
        for (int i2 = 0; i2 < this.patterns.size(); ++i2) {
            TypePattern pi = this.patterns.get(i2);
            if (pi.isStar()) {
                if (seenStar) {
                    scope.getWorld().showMessage(IMessage.ERROR, WeaverMessages.format("circularityInPrecedenceStar"), pi.getSourceLocation(), null);
                }
                seenStar = true;
                continue;
            }
            ResolvedType exactType = pi.getExactType().resolve(scope.getWorld());
            if (exactType.isMissing()) continue;
            if (!(exactType.isAspect() || exactType.isAnnotationStyleAspect() || pi.isIncludeSubtypes() || exactType.isTypeVariableReference())) {
                scope.getWorld().showMessage(IMessage.ERROR, WeaverMessages.format("nonAspectTypesInPrecedence", exactType.getName()), pi.getSourceLocation(), null);
            }
            for (int j2 = 0; j2 < this.patterns.size(); ++j2) {
                TypePattern pj;
                if (j2 == i2 || (pj = this.patterns.get(j2)).isStar() || !pj.matchesStatically(exactType)) continue;
                scope.getWorld().showMessage(IMessage.ERROR, WeaverMessages.format("circularityInPrecedenceTwo", exactType.getName()), pi.getSourceLocation(), pj.getSourceLocation());
            }
        }
    }

    public TypePatternList getPatterns() {
        this.ensureResolved();
        return this.patterns;
    }

    private int matchingIndex(ResolvedType a2) {
        this.ensureResolved();
        int knownMatch = -1;
        int starMatch = -1;
        int len = this.patterns.size();
        for (int i2 = 0; i2 < len; ++i2) {
            TypePattern p2 = this.patterns.get(i2);
            if (p2.isStar()) {
                starMatch = i2;
                continue;
            }
            if (!p2.matchesStatically(a2)) continue;
            if (knownMatch != -1) {
                a2.getWorld().showMessage(IMessage.ERROR, WeaverMessages.format("multipleMatchesInPrecedence", a2, this.patterns.get(knownMatch), p2), this.patterns.get(knownMatch).getSourceLocation(), p2.getSourceLocation());
                return -1;
            }
            knownMatch = i2;
        }
        if (knownMatch == -1) {
            return starMatch;
        }
        return knownMatch;
    }

    public int compare(ResolvedType aspect1, ResolvedType aspect2) {
        this.ensureResolved();
        int index1 = this.matchingIndex(aspect1);
        int index2 = this.matchingIndex(aspect2);
        if (index1 == -1 || index2 == -1) {
            return 0;
        }
        if (index1 == index2) {
            return 0;
        }
        if (index1 > index2) {
            return -1;
        }
        return 1;
    }

    public boolean isAdviceLike() {
        return false;
    }

    public String getNameSuffix() {
        return "precedence";
    }
}

