/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.springtools.domain.attachment;

import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Toolkit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.homelinux.elabor.springtools.domain.attachment.Attachment;

public class Picture {
    public static final String[] contentTypes = new String[]{"image/.*"};
    private int width;
    private int height;
    private Attachment attachment;

    public int getWidth() {
        return this.width;
    }

    private void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    private void setHeight(int height) {
        this.height = height;
    }

    public Attachment getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Attachment attachment) {
        this.attachment = attachment;
        Image image = Toolkit.getDefaultToolkit().createImage(attachment.getContent());
        MediaTracker mediaTracker = new MediaTracker(new Panel());
        int trackID = 0;
        mediaTracker.addImage(image, trackID);
        try {
            mediaTracker.waitForID(trackID);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.setWidth(image.getWidth(null));
        this.setHeight(image.getHeight(null));
    }

    protected static boolean isPicture(Attachment attachment) {
        boolean isPicture = false;
        String[] stringArray = contentTypes;
        int n2 = contentTypes.length;
        int n3 = 0;
        while (n3 < n2) {
            String regex = stringArray[n3];
            Pattern pattern = Pattern.compile(regex);
            Matcher match = pattern.matcher(attachment.getContentType());
            if (match.matches()) {
                isPicture = true;
                break;
            }
            ++n3;
        }
        return isPicture;
    }

    public static Picture getPicture(Attachment attachment) {
        if (Picture.isPicture(attachment)) {
            Picture picture = new Picture();
            picture.setAttachment(attachment);
            return picture;
        }
        return null;
    }
}

