/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.springtools.services;

import java.util.HashMap;
import java.util.Map;
import org.homelinux.elabor.springtools.domain.attachment.Attachment;
import org.homelinux.elabor.springtools.domain.attachment.Picture;
import org.homelinux.elabor.springtools.services.PictureManager;
import org.homelinux.elabor.springtools.services.Thumbnail;

public class PictureManagerImpl
implements PictureManager {
    public static final String ICON = "icon";
    public static final String SMALL = "small";
    public static final String MEDIUM = "medium";
    public static final String LARGE = "large";
    private static final String DEFAULT = "default";
    private static final Integer ICON_SIZE = new Integer(50);
    private static final Integer SMALL_SIZE = new Integer(80);
    private static final Integer MEDIUM_SIZE = new Integer(160);
    private static final Integer LARGE_SIZE = new Integer(320);
    private Map<String, Integer> sizeMap = new HashMap<String, Integer>();

    public PictureManagerImpl() {
        this.sizeMap.put(ICON, ICON_SIZE);
        this.sizeMap.put(SMALL, SMALL_SIZE);
        this.sizeMap.put(MEDIUM, MEDIUM_SIZE);
        this.sizeMap.put(LARGE, LARGE_SIZE);
        this.sizeMap.put(DEFAULT, SMALL_SIZE);
    }

    @Override
    public Attachment getThumbnail(Picture picture) {
        return this.getThumbnail(DEFAULT, picture);
    }

    @Override
    public Attachment getThumbnail(String size, Picture picture) {
        byte[] thumbBytes;
        Attachment thumb = picture.getAttachment().copy();
        try {
            byte[] content = picture.getAttachment().getContent();
            thumbBytes = Thumbnail.createThumbArray(content, this.sizeMap.get(size), this.sizeMap.get(size));
        }
        catch (Exception e2) {
            e2.printStackTrace();
            thumbBytes = new byte[]{};
        }
        thumb.setContent(thumbBytes);
        thumb.setContentType("image/jpeg");
        return thumb;
    }
}

