/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.springtools.web.controllers;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.homelinux.elabor.springtools.domain.attachment.Attachment;
import org.homelinux.elabor.springtools.domain.attachment.AttachmentContainer;
import org.homelinux.elabor.springtools.domain.attachment.DefaultAttachment;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class AttachmentsHandler {
    public void uploadAttachment(HttpServletRequest request, AttachmentContainer container) throws IOException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        MultipartFile content = multipartRequest.getFile("attachment");
        if (content.getSize() > 0L) {
            DefaultAttachment attachment = new DefaultAttachment();
            attachment.setContentType(content.getContentType());
            attachment.setFileName(content.getOriginalFilename());
            attachment.setContent(content.getBytes());
            container.getAttachments().add(attachment);
        }
        request.getSession().setAttribute("container", container);
    }

    public void removeAttachment(AttachmentContainer container, int index) {
        container.getAttachments().remove(index);
    }

    public void sortAttachments(AttachmentContainer container, String attachmentsOrder) {
        List<Attachment> attachments = container.getAttachments();
        if (StringUtils.hasText(attachmentsOrder) && !attachments.isEmpty()) {
            String[] stringOrder = attachmentsOrder.split("\\|");
            Integer[] intOrder = new Integer[stringOrder.length];
            int i2 = 0;
            while (i2 < stringOrder.length) {
                Integer parseInt;
                intOrder[i2] = parseInt = new Integer(stringOrder[i2].split("-")[1]);
                ++i2;
            }
            container.sortAttachments(intOrder);
        }
    }
}

