/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.springtools.web.controllers;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;
import org.homelinux.elabor.text.CharSetHelper;
import org.homelinux.elabor.text.Format;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class ControllerHelper {
    private static final DecimalFormat PRICE_FORMAT = Format.newDecimalFormat(Locale.ITALIAN, "###,##0.00");
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy");

    static {
        DATE_FORMAT.setLenient(false);
    }

    public static void checkEmpty(String name, String value) throws InvalidParameterValue {
        if (value.trim().isEmpty()) {
            throw new InvalidParameterValue(name, value);
        }
    }

    public static void checkEmpty(String name, List<String> value) throws InvalidParameterValue {
        if (value == null || value.isEmpty()) {
            throw new InvalidParameterValue(name, "");
        }
    }

    public static boolean checkBoolean(String name, String valueStr) throws InvalidParameterValue {
        boolean value;
        try {
            value = Boolean.parseBoolean(valueStr.trim());
        }
        catch (NumberFormatException exc) {
            throw new InvalidParameterValue(name, valueStr);
        }
        return value;
    }

    public static String checkString(String name, String value) throws InvalidParameterValue {
        String trimmedValue = value.trim();
        int caratteriSpeciali = CharSetHelper.checkString60LatinType(value);
        if (trimmedValue.isEmpty() || caratteriSpeciali != -1) {
            throw new InvalidParameterValue(name, trimmedValue);
        }
        return trimmedValue;
    }

    public static int checkInt(String name, String stringValue) throws InvalidParameterValue {
        int value;
        try {
            value = Integer.parseInt(stringValue.trim());
        }
        catch (NumberFormatException exc) {
            throw new InvalidParameterValue(name, stringValue);
        }
        return value;
    }

    public static double checkDouble(String name, String stringValue) throws InvalidParameterValue {
        double value;
        try {
            value = PRICE_FORMAT.parse(stringValue.trim()).doubleValue();
        }
        catch (ParseException exc) {
            throw new InvalidParameterValue(name, stringValue);
        }
        return value;
    }

    public static Date checkTime(String name, String dataStr, DateFormat format) throws InvalidParameterValue {
        Date data;
        try {
            data = format.parse(dataStr.trim());
        }
        catch (ParseException e2) {
            throw new InvalidParameterValue(name, dataStr);
        }
        return data;
    }

    public static Date checkData(String name, String dataStr) throws InvalidParameterValue {
        return ControllerHelper.checkTime(name, dataStr, DATE_FORMAT);
    }

    public static Date checkData(String name, String dataStr, DateFormat dateFormat) throws InvalidParameterValue {
        return ControllerHelper.checkTime(name, dataStr, dateFormat);
    }

    public static <E extends Enum<E>> E checkEnum(String nome, String stringValue, Class<E> enumClass) throws InvalidParameterValue {
        E value;
        try {
            value = Enum.valueOf(enumClass, stringValue.trim().toUpperCase());
        }
        catch (Exception exc) {
            throw new InvalidParameterValue(nome, stringValue);
        }
        return value;
    }

    public static void checkTaxCode(String name, String value) throws InvalidParameterValue {
        if (!ControllerHelper.controllerTaxCode(value)) {
            throw new InvalidParameterValue(name, value);
        }
    }

    public static void checckTaxCodeFinto(String name, String value) throws InvalidParameterValue {
        if (value.contains("finto")) {
            throw new InvalidParameterValue(name, value);
        }
    }

    public static boolean controllerTaxCode(String taxCode) {
        int c2;
        int[] nArray = new int[26];
        nArray[0] = 1;
        nArray[2] = 5;
        nArray[3] = 7;
        nArray[4] = 9;
        nArray[5] = 13;
        nArray[6] = 15;
        nArray[7] = 17;
        nArray[8] = 19;
        nArray[9] = 21;
        nArray[10] = 2;
        nArray[11] = 4;
        nArray[12] = 18;
        nArray[13] = 20;
        nArray[14] = 11;
        nArray[15] = 3;
        nArray[16] = 6;
        nArray[17] = 8;
        nArray[18] = 12;
        nArray[19] = 14;
        nArray[20] = 16;
        nArray[21] = 10;
        nArray[22] = 22;
        nArray[23] = 25;
        nArray[24] = 24;
        nArray[25] = 23;
        int[] setdisp = nArray;
        if (taxCode.length() != 16) {
            return false;
        }
        String taxCode2 = taxCode.toUpperCase();
        int i2 = 0;
        while (i2 < 16) {
            c2 = taxCode2.charAt(i2);
            if (!(c2 >= 48 && c2 <= 57 || c2 >= 65 && c2 <= 90)) {
                return false;
            }
            ++i2;
        }
        int s2 = 0;
        i2 = 1;
        while (i2 <= 13) {
            c2 = taxCode2.charAt(i2);
            s2 = c2 >= 48 && c2 <= 57 ? s2 + c2 - 48 : s2 + c2 - 65;
            i2 += 2;
        }
        i2 = 0;
        while (i2 <= 14) {
            c2 = taxCode2.charAt(i2);
            if (c2 >= 48 && c2 <= 57) {
                c2 = c2 - 48 + 65;
            }
            s2 += setdisp[c2 - 65];
            i2 += 2;
        }
        return s2 % 26 + 65 == taxCode2.charAt(15);
    }

    public static void checkLenghtParam(String name, String value, int nCaratteriMin) throws InvalidParameterValue {
        int nCaratteri = value.length();
        if (nCaratteri < nCaratteriMin && nCaratteri > 1) {
            throw new InvalidParameterValue("invalidlenghtname", name, nCaratteriMin);
        }
    }

    public static void checkLenghtPiva(String name, String value) throws InvalidParameterValue {
        int nCaratteri = value.length();
        boolean matches = value.matches("\\d+,?\\d*");
        if (nCaratteri != 11 || !matches) {
            throw new InvalidParameterValue("piva", name, value);
        }
    }

    public static void checkCompanyTaxCode(String name, String value) throws InvalidParameterValue {
        int nCaratteri = value.length();
        boolean matches = value.matches("\\d+,?\\d*");
        if (nCaratteri != 11 || !matches) {
            throw new InvalidParameterValue("piva", name, value);
        }
    }

    public static void checkExactLenghtParam(String name, String value, int nCaratteri) throws InvalidParameterValue {
        if (value.length() != nCaratteri) {
            throw new InvalidParameterValue("invalidexactlenghtname", name, nCaratteri);
        }
    }

    public static void checkFile(String name, MultipartFile file) throws InvalidParameterValue {
        if (file.isEmpty()) {
            throw new InvalidParameterValue(name, file.getOriginalFilename());
        }
    }

    public static Map<String, Object> getParametersMap(HttpServletRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration<String> names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            String[] values = request.getParameterValues(name);
            map.put(name, values);
        }
        if (request instanceof MultipartHttpServletRequest) {
            MultipartHttpServletRequest mpr = (MultipartHttpServletRequest)request;
            MultiValueMap<String, MultipartFile> mpfMap = mpr.getMultiFileMap();
            map.putAll(mpfMap);
        }
        return map;
    }
}

