/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.springtools.web.controllers;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.homelinux.elabor.springtools.web.check.EmptyParameterValue;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;
import org.homelinux.elabor.springtools.web.check.ParameterNotFoundException;
import org.homelinux.elabor.text.Format;

public class ParametersHelper {
    private static final DecimalFormat DOUBLE_FORMAT = Format.newDecimalFormat(Locale.ITALIAN, "#,##0.00");
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy");

    public static String[] getParameterValues(String name, Map<String, Object> paramMap) {
        String[] values = (String[])paramMap.get(name);
        if (values == null) {
            values = new String[]{};
        }
        return values;
    }

    public static String getStringParameter(String name, Map<String, Object> paramMap) throws ParameterNotFoundException, EmptyParameterValue {
        return ParametersHelper.getStringParameter(name, paramMap, null);
    }

    public static String getNullParameter(String name, Map<String, Object> paramMap) throws ParameterNotFoundException, EmptyParameterValue {
        return ParametersHelper.getStringParameter(name, paramMap, "");
    }

    public static String getStringParameter(String name, Map<String, Object> paramMap, String defaultValue) throws ParameterNotFoundException, EmptyParameterValue {
        String value;
        String[] values = ParametersHelper.getParameterValues(name, paramMap);
        if (values.length == 0) {
            if (defaultValue == null) {
                throw new ParameterNotFoundException(name);
            }
            value = defaultValue;
        } else {
            value = values[0];
            if (defaultValue == null && value.isEmpty()) {
                throw new EmptyParameterValue(name);
            }
        }
        return value;
    }

    public static int getIntParameter(String name, Map<String, Object> paramMap) throws ParameterNotFoundException, InvalidParameterValue, EmptyParameterValue {
        int value;
        String stringValue = ParametersHelper.getStringParameter(name, paramMap);
        try {
            value = Integer.parseInt(stringValue);
        }
        catch (NumberFormatException e2) {
            throw new InvalidParameterValue(name, stringValue);
        }
        return value;
    }

    public static int getIntParameter(String name, Map<String, Object> paramMap, int defaultValue) throws ParameterNotFoundException, InvalidParameterValue {
        int value;
        try {
            value = ParametersHelper.getIntParameter(name, paramMap);
        }
        catch (EmptyParameterValue e2) {
            value = defaultValue;
        }
        return value;
    }

    public static double getDoubleParameter(String name, Map<String, Object> paramMap) throws ParameterNotFoundException, InvalidParameterValue, EmptyParameterValue {
        double value;
        String stringValue = ParametersHelper.getStringParameter(name, paramMap);
        try {
            value = DOUBLE_FORMAT.parse(stringValue).doubleValue();
            if (value == 0.0) {
                throw new InvalidParameterValue(name, stringValue);
            }
        }
        catch (ParseException e2) {
            throw new InvalidParameterValue(name, stringValue);
        }
        return value;
    }

    public static double getDoubleParameter(String name, Map<String, Object> paramMap, double defaultValue) throws InvalidParameterValue {
        double value;
        try {
            String stringValue = ParametersHelper.getStringParameter(name, paramMap);
            try {
                value = DOUBLE_FORMAT.parse(stringValue).doubleValue();
            }
            catch (ParseException e2) {
                throw new InvalidParameterValue(name, stringValue);
            }
        }
        catch (EmptyParameterValue exc) {
            value = defaultValue;
        }
        catch (ParameterNotFoundException exc) {
            value = defaultValue;
        }
        return value;
    }

    public static Date getDateParameter(String name, Map<String, Object> paramMap) throws InvalidParameterValue {
        Date value;
        try {
            String stringValue = ParametersHelper.getStringParameter(name, paramMap);
            try {
                value = DATE_FORMAT.parse(stringValue);
            }
            catch (ParseException e2) {
                throw new InvalidParameterValue(name, stringValue);
            }
        }
        catch (EmptyParameterValue exc) {
            value = null;
        }
        catch (ParameterNotFoundException exc) {
            value = null;
        }
        return value;
    }

    public static boolean getBooleanParameter(String name, Map<String, Object> paramMap) {
        return paramMap.get(name) != null;
    }

    public static List<String> getStringsParameter(String name, Map<String, Object> paramMap) {
        return Arrays.asList(ParametersHelper.getParameterValues(name, paramMap));
    }

    public static <T extends Enum<T>> T getEnum(Class<T> enumClass, String name, Map<String, Object> paramMap) throws ParameterNotFoundException, InvalidParameterValue, EmptyParameterValue {
        T value;
        String stringValue = ParametersHelper.getStringParameter(name, paramMap);
        try {
            value = Enum.valueOf(enumClass, stringValue);
        }
        catch (Exception e2) {
            throw new InvalidParameterValue(name, stringValue);
        }
        return value;
    }

    public static double[] getDoublesParameter(String name, Map<String, Object> paramMap) throws InvalidParameterValue {
        String[] paramValues = ParametersHelper.getParameterValues(name, paramMap);
        double[] values = new double[paramValues.length];
        int index = 0;
        String[] stringArray = paramValues;
        int n2 = paramValues.length;
        int n3 = 0;
        while (n3 < n2) {
            String value = stringArray[n3];
            try {
                values[index] = DOUBLE_FORMAT.parse(value).doubleValue();
            }
            catch (ParseException e2) {
                throw new InvalidParameterValue(name, value);
            }
            ++n3;
        }
        return values;
    }

    public static int[] getIntsParameter(String name, Map<String, Object> paramMap) throws InvalidParameterValue {
        String[] paramValues = ParametersHelper.getParameterValues(name, paramMap);
        int[] values = new int[paramValues.length];
        int index = 0;
        String[] stringArray = paramValues;
        int n2 = paramValues.length;
        int n3 = 0;
        while (n3 < n2) {
            String value = stringArray[n3];
            try {
                values[index] = Integer.parseInt(value);
                ++index;
            }
            catch (NumberFormatException e2) {
                throw new InvalidParameterValue(name, value);
            }
            ++n3;
        }
        return values;
    }

    public static List<Integer> getIntsListParameter(String name, Map<String, Object> paramMap) throws InvalidParameterValue {
        String[] paramValues = ParametersHelper.getParameterValues(name, paramMap);
        ArrayList<Integer> values = new ArrayList<Integer>();
        String[] stringArray = paramValues;
        int n2 = paramValues.length;
        int n3 = 0;
        while (n3 < n2) {
            String value = stringArray[n3];
            try {
                values.add(Integer.valueOf(value));
            }
            catch (NumberFormatException e2) {
                throw new InvalidParameterValue(name, value);
            }
            ++n3;
        }
        return values;
    }
}

