/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.structures.safe;

import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.structures.classifier.Store;
import org.homelinux.elabor.structures.classifier.StoreClassifier;
import org.homelinux.elabor.structures.safe.SafeClassifier;
import org.homelinux.elabor.structures.safe.SafeMapError;

public class BasicSafeClassifier<K, V, A>
extends StoreClassifier<K, V, A>
implements SafeClassifier<K, V, A> {
    private final SafeMapError error;

    public BasicSafeClassifier(SafeMapError error, Store<K, V, A> store) {
        super(store);
        this.error = error;
    }

    @Override
    public A get(K key) throws DataNotFoundException {
        Store store = this.getStore();
        return BasicSafeClassifier.get(key, store, this.error);
    }

    public static <K, V, A> A get(K key, Store<K, V, A> store, SafeMapError error) throws DataNotFoundException {
        A value = store.get(key);
        if (value == null) {
            String message = error.getMessage();
            int code = error.getCode();
            String keyString = key == null ? "null" : key.toString();
            throw new DataNotFoundException(message, keyString, code);
        }
        return value;
    }
}

