/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.structures.setmap;

import java.util.Set;
import org.homelinux.elabor.structures.UnfoldedIterable;
import org.homelinux.elabor.structures.classifier.StoreClassifier;
import org.homelinux.elabor.structures.extractors.KeyExtractor;
import org.homelinux.elabor.structures.setmap.SetMap;
import org.homelinux.elabor.structures.setmap.SetMapStore;

public class BasicSetMap<K, V>
extends StoreClassifier<K, V, Set<V>>
implements SetMap<K, V> {
    private final SetMapStore<K, V> store;

    public BasicSetMap() {
        this(new SetMapStore());
    }

    public BasicSetMap(SetMapStore<K, V> store) {
        super(store);
        this.store = store;
    }

    @Override
    public Set<V> get(K key) {
        return (Set)this.getStore().get(key);
    }

    @Override
    public Iterable<V> iterable() {
        return new UnfoldedIterable(this);
    }

    @Override
    public void addAll(K key, Set<V> values) {
        this.store.put(key, values);
    }

    @Override
    public void addAll(Set<V> values, KeyExtractor<K, V> extractor) {
        for (V value : values) {
            K key = extractor.getKey(value);
            if (key == null) continue;
            this.add(key, value);
        }
    }
}

