/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.thread;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.homelinux.elabor.thread.HeartBeatListener;

public class HeartBeat
extends Thread {
    private List<HeartBeatListener> listeners;
    private long milliseconds;
    private boolean active;

    public HeartBeat(long milliseconds) {
        this.milliseconds = milliseconds;
        this.active = false;
        this.listeners = new ArrayList<HeartBeatListener>();
    }

    public void addListener(HeartBeatListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public synchronized void start() {
        Logger logger = Logger.getLogger(this.getClass().getName());
        logger.info("heartbeat starting");
        this.active = true;
        super.start();
        logger.info("heartbeat started");
    }

    @Override
    public void run() {
        Logger logger = Logger.getLogger(this.getClass().getName());
        while (this.active) {
            logger.info("heartbeat beat start");
            for (HeartBeatListener listener : this.listeners) {
                try {
                    listener.beat();
                    logger.info("heartbeat beat ok: " + listener.getClass().getSimpleName());
                }
                catch (Exception exc) {
                    String message = exc.toString();
                    String listenerName = listener.getClass().getSimpleName();
                    logger.severe("heartbeat beat ERROR: " + listenerName + "(" + message + ")");
                }
            }
            logger.info("heartbeat beat end");
            try {
                HeartBeat.sleep(this.milliseconds);
            }
            catch (Exception exc) {
                this.active = false;
                logger.info("heartbeat beat sleep exception: " + exc.getMessage());
                Thread.currentThread().interrupt();
            }
        }
    }

    public void finish() {
        Logger logger = Logger.getLogger(this.getClass().getName());
        logger.info("heartbeat finishing");
        this.active = false;
        this.interrupt();
        while (true) {
            try {
                HeartBeat.sleep(1000L);
            }
            catch (Exception e2) {
                logger.info("heartbeat beat finish sleep exception: " + e2.getMessage());
                Thread.currentThread().interrupt();
            }
            if (!this.isAlive()) break;
            logger.info("heartbeat still alive");
        }
        logger.info("heartbeat finished");
    }
}

