/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.asm.commons;

import org.springframework.asm.Label;
import org.springframework.asm.MethodAdapter;
import org.springframework.asm.MethodVisitor;
import org.springframework.asm.Type;

public class LocalVariablesSorter
extends MethodAdapter {
    private int[] mapping = new int[40];
    protected final int firstLocal;
    private int nextLocal;

    public LocalVariablesSorter(int n2, String string, MethodVisitor methodVisitor) {
        super(methodVisitor);
        Type[] typeArray = Type.getArgumentTypes(string);
        this.nextLocal = (8 & n2) != 0 ? 0 : 1;
        for (int i2 = 0; i2 < typeArray.length; ++i2) {
            this.nextLocal += typeArray[i2].getSize();
        }
        this.firstLocal = this.nextLocal;
    }

    public void visitVarInsn(int n2, int n3) {
        int n4;
        switch (n2) {
            case 22: 
            case 24: 
            case 55: 
            case 57: {
                n4 = 2;
                break;
            }
            default: {
                n4 = 1;
            }
        }
        this.mv.visitVarInsn(n2, this.remap(n3, n4));
    }

    public void visitIincInsn(int n2, int n3) {
        this.mv.visitIincInsn(this.remap(n2, 1), n3);
    }

    public void visitMaxs(int n2, int n3) {
        this.mv.visitMaxs(n2, this.nextLocal);
    }

    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n2) {
        int n3 = "J".equals(string2) || "D".equals(string2) ? 2 : 1;
        this.mv.visitLocalVariable(string, string2, string3, label, label2, this.remap(n2, n3));
    }

    protected int newLocal(int n2) {
        int n3 = this.nextLocal;
        this.nextLocal += n2;
        return n3;
    }

    private int remap(int n2, int n3) {
        int n4;
        if (n2 < this.firstLocal) {
            return n2;
        }
        int n5 = 2 * n2 + n3 - 1;
        int n6 = this.mapping.length;
        if (n5 >= n6) {
            int[] nArray = new int[Math.max(2 * n6, n5 + 1)];
            System.arraycopy(this.mapping, 0, nArray, 0, n6);
            this.mapping = nArray;
        }
        if ((n4 = this.mapping[n5]) == 0) {
            this.mapping[n5] = n4 = this.nextLocal + 1;
            this.nextLocal += n3;
        }
        return n4 - 1;
    }
}

