/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

final class PropertyMatches {
    public static final int DEFAULT_MAX_DISTANCE = 2;
    private final String propertyName;
    private String[] possibleMatches;

    public static PropertyMatches forProperty(String propertyName, Class beanClass) {
        return PropertyMatches.forProperty(propertyName, beanClass, 2);
    }

    public static PropertyMatches forProperty(String propertyName, Class beanClass, int maxDistance) {
        return new PropertyMatches(propertyName, beanClass, maxDistance);
    }

    private PropertyMatches(String propertyName, Class beanClass, int maxDistance) {
        this.propertyName = propertyName;
        this.possibleMatches = this.calculateMatches(BeanUtils.getPropertyDescriptors(beanClass), maxDistance);
    }

    public String[] getPossibleMatches() {
        return this.possibleMatches;
    }

    public String buildErrorMessage() {
        StringBuilder msg = new StringBuilder();
        msg.append("Bean property '");
        msg.append(this.propertyName);
        msg.append("' is not writable or has an invalid setter method. ");
        if (ObjectUtils.isEmpty(this.possibleMatches)) {
            msg.append("Does the parameter type of the setter match the return type of the getter?");
        } else {
            msg.append("Did you mean ");
            int i2 = 0;
            while (i2 < this.possibleMatches.length) {
                msg.append('\'');
                msg.append(this.possibleMatches[i2]);
                if (i2 < this.possibleMatches.length - 2) {
                    msg.append("', ");
                } else if (i2 == this.possibleMatches.length - 2) {
                    msg.append("', or ");
                }
                ++i2;
            }
            msg.append("'?");
        }
        return msg.toString();
    }

    private String[] calculateMatches(PropertyDescriptor[] propertyDescriptors, int maxDistance) {
        ArrayList<String> candidates = new ArrayList<String>();
        PropertyDescriptor[] propertyDescriptorArray = propertyDescriptors;
        int n2 = propertyDescriptors.length;
        int n3 = 0;
        while (n3 < n2) {
            String possibleAlternative;
            PropertyDescriptor pd = propertyDescriptorArray[n3];
            if (pd.getWriteMethod() != null && this.calculateStringDistance(this.propertyName, possibleAlternative = pd.getName()) <= maxDistance) {
                candidates.add(possibleAlternative);
            }
            ++n3;
        }
        Collections.sort(candidates);
        return StringUtils.toStringArray(candidates);
    }

    private int calculateStringDistance(String s1, String s2) {
        if (s1.length() == 0) {
            return s2.length();
        }
        if (s2.length() == 0) {
            return s1.length();
        }
        int[][] d2 = new int[s1.length() + 1][s2.length() + 1];
        int i2 = 0;
        while (i2 <= s1.length()) {
            d2[i2][0] = i2;
            ++i2;
        }
        int j2 = 0;
        while (j2 <= s2.length()) {
            d2[0][j2] = j2;
            ++j2;
        }
        i2 = 1;
        while (i2 <= s1.length()) {
            char s_i = s1.charAt(i2 - 1);
            int j3 = 1;
            while (j3 <= s2.length()) {
                char t_j = s2.charAt(j3 - 1);
                int cost = s_i == t_j ? 0 : 1;
                d2[i2][j3] = Math.min(Math.min(d2[i2 - 1][j3] + 1, d2[i2][j3 - 1] + 1), d2[i2 - 1][j3 - 1] + cost);
                ++j3;
            }
            ++i2;
        }
        return d2[s1.length()][s2.length()];
    }
}

