/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.parsing.FailFastProblemReporter;
import org.springframework.beans.factory.parsing.PassThroughSourceExtractor;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.parsing.SourceExtractor;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.annotation.ConfigurationClassBeanDefinitionReader;
import org.springframework.context.annotation.ConfigurationClassEnhancer;
import org.springframework.context.annotation.ConfigurationClassParser;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ConfigurationClassPostProcessor
implements BeanDefinitionRegistryPostProcessor,
BeanClassLoaderAware {
    private static final boolean cglibAvailable = ClassUtils.isPresent("net.sf.cglib.proxy.Enhancer", ConfigurationClassPostProcessor.class.getClassLoader());
    private final Log logger = LogFactory.getLog(this.getClass());
    private SourceExtractor sourceExtractor = new PassThroughSourceExtractor();
    private ProblemReporter problemReporter = new FailFastProblemReporter();
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private MetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory();
    private boolean setMetadataReaderFactoryCalled = false;
    private boolean postProcessBeanDefinitionRegistryCalled = false;
    private boolean postProcessBeanFactoryCalled = false;

    public void setSourceExtractor(SourceExtractor sourceExtractor) {
        this.sourceExtractor = sourceExtractor != null ? sourceExtractor : new PassThroughSourceExtractor();
    }

    public void setProblemReporter(ProblemReporter problemReporter) {
        this.problemReporter = problemReporter != null ? problemReporter : new FailFastProblemReporter();
    }

    public void setMetadataReaderFactory(MetadataReaderFactory metadataReaderFactory) {
        Assert.notNull(metadataReaderFactory, "MetadataReaderFactory must not be null");
        this.metadataReaderFactory = metadataReaderFactory;
        this.setMetadataReaderFactoryCalled = true;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
        if (!this.setMetadataReaderFactoryCalled) {
            this.metadataReaderFactory = new CachingMetadataReaderFactory(beanClassLoader);
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) {
        if (this.postProcessBeanDefinitionRegistryCalled) {
            throw new IllegalStateException("postProcessBeanDefinitionRegistry already called for this post-processor");
        }
        if (this.postProcessBeanFactoryCalled) {
            throw new IllegalStateException("postProcessBeanFactory already called for this post-processor");
        }
        this.postProcessBeanDefinitionRegistryCalled = true;
        this.processConfigBeanDefinitions(registry);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        if (this.postProcessBeanFactoryCalled) {
            throw new IllegalStateException("postProcessBeanFactory already called for this post-processor");
        }
        this.postProcessBeanFactoryCalled = true;
        if (!this.postProcessBeanDefinitionRegistryCalled) {
            this.processConfigBeanDefinitions((BeanDefinitionRegistry)((Object)beanFactory));
        }
        this.enhanceConfigurationClasses(beanFactory);
    }

    public void processConfigBeanDefinitions(BeanDefinitionRegistry registry) {
        LinkedHashSet<BeanDefinitionHolder> configCandidates = new LinkedHashSet<BeanDefinitionHolder>();
        String[] stringArray = registry.getBeanDefinitionNames();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String beanName = stringArray[n3];
            BeanDefinition beanDef = registry.getBeanDefinition(beanName);
            if (ConfigurationClassBeanDefinitionReader.checkConfigurationClassCandidate(beanDef, this.metadataReaderFactory)) {
                configCandidates.add(new BeanDefinitionHolder(beanDef, beanName));
            }
            ++n3;
        }
        if (configCandidates.isEmpty()) {
            return;
        }
        ConfigurationClassParser parser = new ConfigurationClassParser(this.metadataReaderFactory, this.problemReporter);
        for (BeanDefinitionHolder holder : configCandidates) {
            BeanDefinition bd = holder.getBeanDefinition();
            try {
                if (bd instanceof AbstractBeanDefinition && ((AbstractBeanDefinition)bd).hasBeanClass()) {
                    parser.parse(((AbstractBeanDefinition)bd).getBeanClass(), holder.getBeanName());
                    continue;
                }
                parser.parse(bd.getBeanClassName(), holder.getBeanName());
            }
            catch (IOException ex) {
                throw new BeanDefinitionStoreException("Failed to load bean class: " + bd.getBeanClassName(), ex);
            }
        }
        parser.validate();
        ConfigurationClassBeanDefinitionReader reader = new ConfigurationClassBeanDefinitionReader(registry, this.sourceExtractor, this.problemReporter, this.metadataReaderFactory);
        reader.loadBeanDefinitions(parser.getConfigurationClasses());
    }

    public void enhanceConfigurationClasses(ConfigurableListableBeanFactory beanFactory) {
        LinkedHashMap<String, AbstractBeanDefinition> configBeanDefs = new LinkedHashMap<String, AbstractBeanDefinition>();
        String[] stringArray = beanFactory.getBeanDefinitionNames();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String beanName = stringArray[n3];
            BeanDefinition beanDef = beanFactory.getBeanDefinition(beanName);
            if (ConfigurationClassBeanDefinitionReader.isFullConfigurationClass(beanDef)) {
                if (!(beanDef instanceof AbstractBeanDefinition)) {
                    throw new BeanDefinitionStoreException("Cannot enhance @Configuration bean definition '" + beanName + "' since it is not stored in an AbstractBeanDefinition subclass");
                }
                configBeanDefs.put(beanName, (AbstractBeanDefinition)beanDef);
            }
            ++n3;
        }
        if (configBeanDefs.isEmpty()) {
            return;
        }
        if (!cglibAvailable) {
            throw new IllegalStateException("CGLIB is required to process @Configuration classes. Either add CGLIB to the classpath or remove the following @Configuration bean definitions: " + configBeanDefs.keySet());
        }
        ConfigurationClassEnhancer enhancer = new ConfigurationClassEnhancer(beanFactory);
        for (Map.Entry entry : configBeanDefs.entrySet()) {
            AbstractBeanDefinition beanDef = (AbstractBeanDefinition)entry.getValue();
            try {
                Class configClass = beanDef.resolveBeanClass(this.beanClassLoader);
                Class<?> enhancedClass = enhancer.enhance(configClass);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(String.format("Replacing bean definition '%s' existing class name '%s' with enhanced class name '%s'", entry.getKey(), configClass.getName(), enhancedClass.getName()));
                }
                beanDef.setBeanClass(enhancedClass);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Cannot load configuration class: " + beanDef.getBeanClassName(), ex);
            }
        }
    }
}

